/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.xwork;

import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.plugin.xwork.PluginAwareActionConfig;
import com.atlassian.bamboo.plugin.xwork.XWorkModuleDescriptorInterceptorParser;
import com.atlassian.bamboo.plugin.xwork.XWorkModuleDescriptorParser;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.webwork.StrutsSupport;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class XWorkModuleDescriptor
extends AbstractBambooModuleDescriptor<Void>
implements ConfigurationProvider {
    private static final Logger log = Logger.getLogger(XWorkModuleDescriptor.class);
    private List<PackageConfig> packages;
    private Element moduleElement;
    private Configuration configuration;
    private ObjectFactory objectFactory;

    public XWorkModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element moduleElement) throws PluginParseException {
        super.init(plugin, moduleElement);
        this.moduleElement = moduleElement;
    }

    @Override
    public Void getModule() {
        return null;
    }

    public void destroy() {
    }

    public void init(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public void register(ContainerBuilder containerBuilder, LocatableProperties locatableProperties) throws ConfigurationException {
    }

    public void loadPackages() throws ConfigurationException {
        for (PackageConfig packageConfig : this.getPackages()) {
            this.configuration.addPackageConfig(packageConfig.getName(), packageConfig);
        }
    }

    public boolean needsReload() {
        return false;
    }

    private Iterable<PackageConfig> getPackages() {
        if (this.packages == null) {
            Collection<ConfigurationManager> configurationManagers = StrutsSupport.getDispatchers().getConfigurationManagers();
            Configuration config = ((ConfigurationManager)BambooIterables.getFirst(configurationManagers)).getConfiguration();
            this.packages = this.getPackages(this.moduleElement, config);
        }
        return this.packages;
    }

    @VisibleForTesting
    List<PackageConfig> getPackages(Element element, Configuration configuration) {
        ArrayList<PackageConfig> configuredPackages = new ArrayList<PackageConfig>();
        Iterator it = element.elementIterator("package");
        while (it.hasNext()) {
            Element packageElement = (Element)it.next();
            PackageConfig.Builder newPackage = XWorkModuleDescriptorParser.buildPackageContext(packageElement, configuration);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading " + newPackage));
            }
            try {
                XWorkModuleDescriptorParser.addResultTypes(newPackage, packageElement);
                XWorkModuleDescriptorInterceptorParser.loadInterceptors(this.objectFactory, newPackage, packageElement);
                XWorkModuleDescriptorInterceptorParser.loadDefaultInterceptorRef(newPackage, packageElement);
                XWorkModuleDescriptorParser.loadGlobalResults(newPackage, packageElement);
                Iterator actionIt = packageElement.elementIterator("action");
                while (actionIt.hasNext()) {
                    Element actionElement = (Element)actionIt.next();
                    this.addAction(actionElement, newPackage);
                }
                configuredPackages.add(newPackage.build());
            }
            catch (ConfigurationException e) {
                log.error((Object)("Could not add package: " + newPackage + " because: " + (Object)((Object)e)), (Throwable)e);
            }
        }
        return configuredPackages;
    }

    private void addAction(Element actionElement, final PackageConfig.Builder packageConfigBuilder) throws ConfigurationException {
        Map<String, ResultConfig> results;
        final String name = actionElement.attributeValue("name");
        final String className = actionElement.attributeValue("class");
        String methodName = actionElement.attributeValue("method");
        methodName = StringUtils.isBlank((CharSequence)methodName) ? null : methodName.trim();
        String msg = "A problem has occurred when instantiating action class [" + className + "], skipping action [" + name + "]";
        Object wiredAction = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Callable<Object>(msg){

            @Override
            public Object call() throws Exception {
                PluginAwareActionConfig actionConfig = new PluginAwareActionConfig(new ActionConfig.Builder(null, name, className).build(), XWorkModuleDescriptor.this.plugin);
                return XWorkModuleDescriptor.this.objectFactory.buildAction(name, packageConfigBuilder.getNamespace(), (ActionConfig)actionConfig, null);
            }
        });
        if (wiredAction == null) {
            return;
        }
        Map<String, String> actionParams = XWorkModuleDescriptorParser.getParams(actionElement);
        try {
            results = XWorkModuleDescriptorParser.buildResults(actionElement, packageConfigBuilder);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageConfigBuilder.getNamespace(), (Throwable)e);
        }
        List<InterceptorMapping> interceptorList = XWorkModuleDescriptorInterceptorParser.buildInterceptorList(this.objectFactory, actionElement, packageConfigBuilder);
        Set<String> allowedMethods = XWorkModuleDescriptorParser.buildAllowedMethods(actionElement, packageConfigBuilder, methodName);
        PluginAwareActionConfig actionConfig = new PluginAwareActionConfig(new ActionConfig.Builder(packageConfigBuilder.getName(), name, className).methodName(methodName).addParams(actionParams).addResultConfigs(results).addInterceptors(interceptorList).addAllowedMethod(allowedMethods).build(), this.plugin);
        packageConfigBuilder.addActionConfig(name, (ActionConfig)actionConfig);
        if (log.isDebugEnabled()) {
            String namespace = (String)StringUtils.defaultIfEmpty((CharSequence)(packageConfigBuilder.getNamespace() + "/"), (CharSequence)"");
            log.debug((Object)("Loaded " + namespace + name + " in '" + packageConfigBuilder.getName() + "' package:" + (Object)((Object)actionConfig)));
        }
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

