/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.xwork;

import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.xwork.XWorkModuleDescriptorParser;
import com.atlassian.bamboo.utils.Dom4jUtils;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.InterceptorLocator;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;

final class XWorkModuleDescriptorInterceptorParser {
    private static final Logger log = Logger.getLogger(XWorkModuleDescriptorInterceptorParser.class);
    private static final ImmutableMap<String, String> STRUTS21_INTERCEPTOR_NAMES = ImmutableMap.builder().put((Object)"model-driven", (Object)"modelDriven").put((Object)"static-params", (Object)"staticParams").put((Object)"scoped-model-driven", (Object)"scopedModelDriven").put((Object)"servlet-config", (Object)"servletConfig").put((Object)"token-session", (Object)"tokenSession").build();

    private XWorkModuleDescriptorInterceptorParser() {
    }

    static void loadDefaultInterceptorRef(PackageConfig.Builder configBuilder, Element element) {
        List<Element> resultTypeList = Dom4jUtils.elements(element, "default-interceptor-ref");
        if (!resultTypeList.isEmpty()) {
            Element defaultRefElement = resultTypeList.get(0);
            configBuilder.defaultInterceptorRef(defaultRefElement.attributeValue("name"));
        }
    }

    static List<InterceptorMapping> lookupInterceptorReference(ObjectFactory objectFactory, PackageConfig.Builder configBuilder, Element interceptorRefElement) throws ConfigurationException {
        String refName = XWorkModuleDescriptorParser.translateToStruts21IfNeeded(STRUTS21_INTERCEPTOR_NAMES, interceptorRefElement.attributeValue("name"));
        Map<String, String> refParams = XWorkModuleDescriptorParser.getParams(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference((InterceptorLocator)configBuilder, (String)refName, refParams, null, (ObjectFactory)objectFactory);
    }

    private static InterceptorStackConfig loadInterceptorStack(ObjectFactory objectFactory, Element element, PackageConfig.Builder configBuilder) throws ConfigurationException {
        String name = element.attributeValue("name");
        InterceptorStackConfig.Builder config = new InterceptorStackConfig.Builder(name);
        for (Element interceptorRefElement : Dom4jUtils.elements(element, "interceptor-ref")) {
            List<InterceptorMapping> interceptors = XWorkModuleDescriptorInterceptorParser.lookupInterceptorReference(objectFactory, configBuilder, interceptorRefElement);
            config.addInterceptors(interceptors);
        }
        return config.build();
    }

    private static void loadInterceptorStacks(ObjectFactory objectFactory, Element element, PackageConfig.Builder configBuilder) throws ConfigurationException {
        for (Element interceptorStack : Dom4jUtils.elements(element, "interceptor-stack")) {
            InterceptorStackConfig config = XWorkModuleDescriptorInterceptorParser.loadInterceptorStack(objectFactory, interceptorStack, configBuilder);
            configBuilder.addInterceptorStackConfig(config);
        }
    }

    static void loadInterceptors(final ObjectFactory objectFactory, final PackageConfig.Builder configBuilder, Element element) throws ConfigurationException {
        for (Element interceptorElement : Dom4jUtils.elements(element, "interceptor")) {
            final String name = interceptorElement.attributeValue("name");
            final String className = interceptorElement.attributeValue("class");
            final Map<String, String> params = XWorkModuleDescriptorParser.getParams(interceptorElement);
            String msg = "Unable to instantiate class " + className + " for interceptor name " + name + ". This interceptor will not be available.";
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Callable<Interceptor>(msg){

                @Override
                public Interceptor call() throws Exception {
                    InterceptorConfig config = new InterceptorConfig.Builder(name, className).addParams(params).build();
                    Interceptor interceptor = objectFactory.buildInterceptor(config, new HashMap());
                    configBuilder.addInterceptorConfig(config);
                    return interceptor;
                }
            });
        }
        XWorkModuleDescriptorInterceptorParser.loadInterceptorStacks(objectFactory, element, configBuilder);
    }

    @NotNull
    static List<InterceptorMapping> buildInterceptorList(ObjectFactory objectFactory, Element element, PackageConfig.Builder configBuilder) throws ConfigurationException {
        return XWorkModuleDescriptorParser.directChildrenElements(element, "interceptor-ref").map(interceptorRef -> XWorkModuleDescriptorInterceptorParser.lookupInterceptorReference(objectFactory, configBuilder, interceptorRef)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

