/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.xwork;

import com.atlassian.bamboo.utils.Dom4jUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationUtil;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XWorkModuleDescriptorParser {
    private static final Logger log = Logger.getLogger(XWorkModuleDescriptorParser.class);
    @VisibleForTesting
    static final String ALL_METHODS_ALLOWED = "regex:.*";
    private static final ImmutableMap<String, String> STRUTS21_RESULT_TYPES = ImmutableMap.of((Object)"redirect-action", (Object)"redirectAction", (Object)"plaintext", (Object)"plainText");

    private XWorkModuleDescriptorParser() {
    }

    @NotNull
    static Map<String, String> getParams(Element paramsElement) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramsElement == null) {
            return params;
        }
        List<Element> childNodes = Dom4jUtils.elements(paramsElement);
        for (Element childNode : childNodes) {
            if (childNode.getNodeType() != 1 || !"param".equals(childNode.getName())) continue;
            String paramName = childNode.attributeValue("name");
            if (childNode.getText() == null) continue;
            String paramValue = childNode.getText();
            params.put(paramName, paramValue);
        }
        return params;
    }

    static Stream<Element> directChildrenElements(Element element, String name) {
        return Dom4jUtils.elements(element, name).stream().filter(e -> e.getParent().equals(element));
    }

    @Nullable
    static String translateToStruts21IfNeeded(Map<String, String> conversionMap, @Nullable String unconverted) {
        if (unconverted == null) {
            return null;
        }
        String converted = conversionMap.get(unconverted);
        return (String)MoreObjects.firstNonNull((Object)converted, (Object)unconverted);
    }

    static PackageConfig.Builder buildPackageContext(Element packageElement, Configuration configuration) {
        String name = TextUtils.noNull((String)packageElement.attributeValue("name"));
        String namespace = TextUtils.noNull((String)packageElement.attributeValue("namespace"));
        String parent = packageElement.attributeValue("extends");
        String abstractVal = packageElement.attributeValue("abstract");
        boolean isAbstract = Boolean.parseBoolean(abstractVal);
        String externalReferenceResolver = TextUtils.noNull((String)packageElement.attributeValue("externalReferenceResolver"));
        if (!Strings.isNullOrEmpty((String)externalReferenceResolver)) {
            log.error((Object)("External reference resolvers are no longer supported, ignoring " + externalReferenceResolver));
        }
        PackageConfig.Builder builder = new PackageConfig.Builder(name).namespace(namespace).isAbstract(isAbstract);
        if (Strings.isNullOrEmpty((String)parent)) {
            return builder;
        }
        List parents = ConfigurationUtil.buildParentsFromString((Configuration)configuration, (String)parent);
        if (!parents.isEmpty()) {
            return builder.addParents(parents);
        }
        log.error((Object)("Unable to find parent packages for " + parent));
        return builder;
    }

    static void addResultTypes(PackageConfig.Builder packageConfigBuilder, Element element) {
        for (Element resultTypeElement : Dom4jUtils.elements(element, "result-type")) {
            String name = resultTypeElement.attributeValue("name");
            String className = resultTypeElement.attributeValue("class");
            String def = resultTypeElement.attributeValue("default");
            try {
                ClassLoaderUtil.loadClass((String)className, XmlConfigurationProvider.class);
                ResultTypeConfig resultType = new ResultTypeConfig.Builder(name, className).build();
                packageConfigBuilder.addResultTypeConfig(resultType);
                if (!Boolean.parseBoolean(def)) continue;
                packageConfigBuilder.defaultResultType(name);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Result class [" + className + "] doesn't exist, ignoring"));
            }
        }
    }

    static void loadGlobalResults(PackageConfig.Builder configBuilder, Element packageElement) {
        List<Element> globalResultList = Dom4jUtils.elements(packageElement, "global-results");
        if (!globalResultList.isEmpty()) {
            Element globalResultElement = globalResultList.get(0);
            Map<String, ResultConfig> results = XWorkModuleDescriptorParser.buildResults(globalResultElement, configBuilder);
            configBuilder.addGlobalResultConfigs(results);
        }
    }

    @NotNull
    static Map<String, ResultConfig> buildResults(Element element, PackageConfig.Builder configBuilder) {
        HashMap<String, ResultConfig> results = new HashMap<String, ResultConfig>();
        for (Element resultElement : XWorkModuleDescriptorParser.directChildrenElements(element, "result").collect(Collectors.toList())) {
            Class<?> resultClass;
            ResultTypeConfig config;
            String resultName = resultElement.attributeValue("name");
            String resultType = resultElement.attributeValue("type");
            if (StringUtils.isEmpty((CharSequence)resultType)) {
                resultType = configBuilder.getFullDefaultResultType();
            }
            if ((config = configBuilder.getResultType(resultType = XWorkModuleDescriptorParser.translateToStruts21IfNeeded(STRUTS21_RESULT_TYPES, resultType))) == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'");
            }
            String resultClassString = config.getClassName();
            try {
                resultClass = Class.forName(resultClassString);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("There is no result type class found for '" + resultClassString);
            }
            Map<String, String> params = XWorkModuleDescriptorParser.getParams(resultElement);
            if (params.isEmpty() && Dom4jUtils.elements(resultElement).isEmpty() && resultElement.getText() != null) {
                params = new HashMap<String, String>();
                try {
                    String paramName = (String)resultClass.getField("DEFAULT_PARAM").get(null);
                    params.put(paramName, resultElement.getText());
                }
                catch (Throwable paramName) {
                    // empty catch block
                }
            }
            ResultConfig resultConfig = new ResultConfig.Builder(resultName, resultClass.getName()).addParams(params).build();
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    @NotNull
    static Set<String> buildAllowedMethods(Element element, PackageConfig.Builder packageConfigBuilder, @Nullable String methodName) {
        Set<Object> allowedMethods;
        List<Element> allowedMethodsEls = Dom4jUtils.elements(element, "allowed-methods");
        if (!allowedMethodsEls.isEmpty()) {
            allowedMethods = new HashSet();
            String allowedMethodsString = ((Element)Iterables.getOnlyElement(allowedMethodsEls)).getStringValue().trim();
            if (!allowedMethodsString.isEmpty()) {
                allowedMethods.addAll(TextParseUtil.commaDelimitedStringToSet((String)allowedMethodsString));
            }
        } else {
            allowedMethods = packageConfigBuilder.isStrictMethodInvocation() ? Collections.singleton(ALL_METHODS_ALLOWED) : Collections.singleton("*");
        }
        return allowedMethods;
    }
}

