/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.xwork;

import com.atlassian.bamboo.plugin.xwork.XWorkModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.webwork.StrutsSupport;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class XWorkPluginConfigurationMaintainer {
    private static final Logger log = Logger.getLogger(XWorkPluginConfigurationMaintainer.class);
    private final PluginEventManager pluginEventManager;
    private static volatile boolean disableReloads;

    public XWorkPluginConfigurationMaintainer(@NotNull PluginEventManager pluginEventManager) {
        this.pluginEventManager = pluginEventManager;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }

    @PluginEventListener
    public synchronized void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        ModuleDescriptor module = event.getModule();
        XWorkModuleDescriptor xwork = (XWorkModuleDescriptor)((Object)Narrow.downTo((Object)module, XWorkModuleDescriptor.class));
        if (xwork == null) {
            return;
        }
        try {
            StrutsSupport.getDispatchers().replaceContainerProvider(xwork);
            XWorkPluginConfigurationMaintainer.reloadConfigurationIfReloadsEnabled("enabled " + event.getModule().getCompleteKey());
        }
        catch (Throwable t) {
            log.error((Object)("Error while reloading XWork configuration to include " + event.getModule()), t);
        }
    }

    @PluginEventListener
    public synchronized void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        ModuleDescriptor module = event.getModule();
        XWorkModuleDescriptor xwork = (XWorkModuleDescriptor)((Object)Narrow.downTo((Object)module, XWorkModuleDescriptor.class));
        if (xwork == null) {
            return;
        }
        try {
            StrutsSupport.getDispatchers().removeContainerProvider(xwork);
            XWorkPluginConfigurationMaintainer.reloadConfigurationIfReloadsEnabled("disabled " + event.getModule().getCompleteKey());
        }
        catch (Throwable t) {
            log.error((Object)("Error while reloading XWork configuration to remove " + event.getModule()), t);
        }
    }

    private static void reloadConfigurationIfReloadsEnabled(String reason) {
        if (disableReloads) {
            return;
        }
        log.info((Object)("Reloading Struts configuration (" + reason + ")..."));
        StrutsSupport.getDispatchers().reload();
        log.info((Object)("Struts configuration reloaded (" + reason + ")."));
    }

    public static void suspendReloads() {
        disableReloads = true;
    }

    public static void resumeReloads() {
        disableReloads = false;
        XWorkPluginConfigurationMaintainer.reloadConfigurationIfReloadsEnabled("Struts configuration reloads enabled");
    }
}

