/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.BackgroundTaskProcesses;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.bamboo.v2.build.BuildKey;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.Watchdog;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Runnables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class BackgroundTaskProcessesImpl
implements BackgroundTaskProcesses {
    private final HashMultimap<String, ExternalProcess> processesOfTaskExecution = HashMultimap.create();
    private final HashMultimap<BuildKey, ExternalProcess> processesOfResult = HashMultimap.create();
    private final Map<ExternalProcess, ProcessContext> tasksOfProcesses = new HashMap<ExternalProcess, ProcessContext>();
    private final Map<ExternalProcess, Optional<Runnable>> completionCallbacksOfProcesses = new HashMap<ExternalProcess, Optional<Runnable>>();

    BackgroundTaskProcessesImpl() {
    }

    @NotNull
    private static String makeTaskExecutionKey(@NotNull ProcessContext processContext) {
        return BackgroundTaskProcessesImpl.makeTaskExecutionKey(processContext.getBuildKey(), processContext.getTaskId());
    }

    @NotNull
    private static String makeTaskExecutionKey(BuildKey buildKey, long id) {
        return buildKey + ":" + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull ProcessContext processContext, @NotNull ExternalProcess process, Optional<Runnable> completionCallback) {
        HashMultimap<BuildKey, ExternalProcess> hashMultimap = this.processesOfResult;
        synchronized (hashMultimap) {
            this.tasksOfProcesses.put(process, processContext);
            this.processesOfTaskExecution.put((Object)BackgroundTaskProcessesImpl.makeTaskExecutionKey(processContext), (Object)process);
            this.processesOfResult.put((Object)processContext.getBuildKey(), (Object)process);
            this.completionCallbacksOfProcesses.put(process, completionCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BackgroundTaskProcesses.BackgroundTaskProcessesFacade of(@NotNull BuildKey buildKey) {
        HashMultimap<BuildKey, ExternalProcess> hashMultimap = this.processesOfResult;
        synchronized (hashMultimap) {
            this.cleanUp();
            Map<ExternalProcess, ProcessContext> externalProcesses = this.processesOfResult.get((Object)buildKey).stream().collect(Collectors.toMap(process -> process, this.tasksOfProcesses::get));
            return new BackgroundTaskProcessesFacadeImpl(externalProcesses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BackgroundTaskProcesses.BackgroundTaskProcessesFacade of(@NotNull BuildKey buildKey, long taskId) {
        HashMultimap<BuildKey, ExternalProcess> hashMultimap = this.processesOfResult;
        synchronized (hashMultimap) {
            Map<ExternalProcess, ProcessContext> externalProcesses = this.processesOfTaskExecution.get((Object)BackgroundTaskProcessesImpl.makeTaskExecutionKey(buildKey, taskId)).stream().collect(Collectors.toMap(process -> process, this.tasksOfProcesses::get));
            return new BackgroundTaskProcessesFacadeImpl(externalProcesses);
        }
    }

    private void cleanUp() {
        Set deadProcesses = this.tasksOfProcesses.keySet().stream().filter(process -> !process.isAlive()).collect(Collectors.toSet());
        for (ExternalProcess deadProcess : deadProcesses) {
            Set<ExternalProcess> deadProcessCollection = Collections.singleton(deadProcess);
            this.tasksOfProcesses.remove(deadProcess);
            this.processesOfResult.values().removeAll(deadProcessCollection);
            this.processesOfTaskExecution.values().removeAll(deadProcessCollection);
            this.completionCallbacksOfProcesses.remove(deadProcess).orElse(Runnables.doNothing()).run();
        }
    }

    private static class BackgroundTaskProcessesFacadeImpl
    implements BackgroundTaskProcesses.BackgroundTaskProcessesFacade {
        private static final Logger log = Logger.getLogger(BackgroundTaskProcessesFacadeImpl.class);
        private final Map<ExternalProcess, ProcessContext> processes;

        private BackgroundTaskProcessesFacadeImpl(Map<ExternalProcess, ProcessContext> externalProcesses) {
            this.processes = ImmutableMap.copyOf(externalProcesses);
        }

        public void finish(BuildLogger buildLogger) {
            for (Map.Entry<ExternalProcess, ProcessContext> processOfTask : this.processes.entrySet()) {
                ExternalProcess process = processOfTask.getKey();
                ProcessContext task = processOfTask.getValue();
                String startedByTask = null;
                if (StringUtils.isNotBlank((CharSequence)task.getTaskDescription())) {
                    startedByTask = " started by " + task.getTaskDescription() + ' ';
                }
                log.info((Object)buildLogger.addBuildLogEntry("Waiting for the background process [" + process.getCommandLine() + "] " + startedByTask + "to terminate..."));
                process.finish();
            }
        }

        @NotNull
        public Map<ExternalProcess, ProcessContext> cancel() {
            Map<ExternalProcess, ProcessContext> processesAlive = this.processes.entrySet().stream().filter(e -> ((ExternalProcess)e.getKey()).isAlive()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            processesAlive.keySet().forEach(Watchdog::cancel);
            return processesAlive;
        }
    }
}

