/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.EnvironmentVariableStringUtils;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariableAccessorImpl
implements EnvironmentVariableAccessor {
    private static final Logger log = Logger.getLogger(EnvironmentVariableAccessorImpl.class);
    private static final Pattern INVALID_ENV_IDENTIFIER_CHAR = Pattern.compile("[^a-zA-Z0-9_]");
    private final CapabilityContext capabilityContext;
    private final CustomVariableContext customVariableContext;

    public EnvironmentVariableAccessorImpl(CapabilityContext capabilityContext, CustomVariableContext customVariableContext) {
        this.capabilityContext = capabilityContext;
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return System.getenv();
    }

    @NotNull
    public Map<String, String> getEnvironment(@NotNull CommonTaskContext taskContext) {
        String javaHome;
        HashMap<String, String> environment = new HashMap<String, String>();
        for (Map.Entry variable : this.customVariableContext.getVariableContexts().entrySet()) {
            String key = ((String)variable.getKey()).startsWith("bamboo") ? (String)variable.getKey() : "bamboo." + (String)variable.getKey();
            environment.put(EnvironmentVariableAccessorImpl.forceLegalIdentifier(key), ((VariableDefinitionContext)variable.getValue()).getValue());
        }
        if (!taskContext.getCommonContext().getDockerPipelineConfiguration().isEnabled() && (javaHome = this.getJavaHome(taskContext)) != null) {
            environment.put("JAVA_HOME", javaHome);
        }
        return environment;
    }

    @NotNull
    public List<String> getPaths(@NotNull CommonTaskContext taskContext) {
        ArrayList<String> paths = new ArrayList<String>();
        String javaHome = this.getJavaHome(taskContext);
        if (javaHome != null) {
            if (SystemUtils.IS_OS_WINDOWS && !javaHome.contains("/")) {
                paths.add(String.format("%s\\bin", javaHome));
            } else {
                paths.add(String.format("%s/bin", javaHome));
            }
        }
        return paths;
    }

    @NotNull
    public String joinEnvironmentVariables(@NotNull Map<String, String> environmentVariables) {
        return this.joinEnvironmentVariables(environmentVariables.entrySet());
    }

    @NotNull
    public String joinEnvironmentVariables(@NotNull Iterable<Map.Entry<String, String>> environmentVariables) {
        return StringUtils.join(Iterables.transform(environmentVariables, (Function)CreateEnvironmentAssignment.INSTANCE).iterator(), (String)" ");
    }

    @NotNull
    public Map<String, String> splitEnvironmentAssignments(@NotNull String environmentAssignments, boolean processBackslashes) {
        HashMap<String, String> results = new HashMap<String, String>();
        HashMap<String, String> tokenizedString = new HashMap<String, String>();
        EnvironmentVariableStringUtils.tokeniseVariables(tokenizedString, environmentAssignments, processBackslashes);
        for (Map.Entry var : tokenizedString.entrySet()) {
            String varName = (String)var.getKey();
            String quotedVarValue = (String)var.getValue();
            String unquotedVarValue = BambooStringUtils.unquote((String)quotedVarValue, (boolean)processBackslashes);
            varName = StringUtils.removeStart((String)varName, (String)"-D");
            results.put(varName, unquotedVarValue);
        }
        return results;
    }

    @NotNull
    public Map<String, String> splitEnvironmentAssignments(@NotNull String environmentAssignments) {
        return this.splitEnvironmentAssignments(environmentAssignments, false);
    }

    public void validateEnvironmentVariables(@NotNull Map<String, String> environmentVariables) {
        this.validateEnvironmentVariables(environmentVariables.entrySet());
    }

    public void validateEnvironmentVariables(@NotNull Iterable<Map.Entry<String, String>> environmentVariables) {
        TreeSet variableNamesNoCase = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        HashSet variableNamesWithCase = new HashSet();
        long totalLength = 0L;
        for (Map.Entry<String, String> entry : environmentVariables) {
            String variableName = entry.getKey();
            String variableValue = entry.getValue();
            if (variableValue != null) {
                totalLength += (long)(variableName.length() + "=".length() + variableValue.length() + 2);
                if (variableValue.length() > 2047) {
                    log.warn((Object)("Variable " + variableName + " may be too long, make sure that the builder environment variable values are as expected"));
                }
                if (variableNamesWithCase.contains(variableName)) {
                    log.warn((Object)("Detected a clash on variable " + variableName + ", make sure that the builder environment variable values are as expected"));
                    continue;
                }
                if (!variableNamesNoCase.contains(variableName)) continue;
                log.warn((Object)("Detected a clash between variable names: " + variableName + " and " + variableNamesNoCase.subSet(variableName, true, variableName, true) + ", build is platform-dependent"));
                continue;
            }
            log.warn((Object)("Environment variable " + variableName + " is null"));
        }
        if (totalLength > 4096L) {
            log.warn((Object)("The size of environment is " + totalLength + ", make sure your build environment handles this correctly "));
        } else {
            log.debug((Object)("The size of environment is " + totalLength));
        }
    }

    @Nullable
    private String getJavaHome(@NotNull CommonTaskContext taskContext) {
        String jdkLabel = (String)taskContext.getConfigurationMap().get((Object)"buildJdk");
        if (jdkLabel != null) {
            return this.capabilityContext.getCapabilityValue("system.jdk." + jdkLabel);
        }
        return null;
    }

    @NotNull
    public static String forceLegalIdentifier(@NotNull String key) {
        String legalIdentifier = INVALID_ENV_IDENTIFIER_CHAR.matcher(key).replaceAll("_");
        return !CharUtils.isAsciiNumeric((char)key.charAt(0)) ? legalIdentifier : "_" + legalIdentifier;
    }

    private static enum CreateEnvironmentAssignment implements Function<Map.Entry<String, String>, String>
    {
        INSTANCE;


        public String apply(@Nullable Map.Entry<String, String> input) {
            return String.format("%s=%s", EnvironmentVariableAccessorImpl.forceLegalIdentifier((String)((Map.Entry)Preconditions.checkNotNull(input)).getKey()), ((Map.Entry)Preconditions.checkNotNull(input)).getValue());
        }
    }
}

