/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

class EnvironmentVariableStringUtils {
    private static final Logger log = Logger.getLogger(EnvironmentVariableStringUtils.class);

    private EnvironmentVariableStringUtils() {
    }

    public static void tokeniseVariables(Map<String, String> vars, String toParse, boolean processBackslashes) {
        if (StringUtils.isBlank((CharSequence)toParse)) {
            return;
        }
        int varNameDelimiterPos = StringUtils.indexOfAny((CharSequence)(toParse = StringUtils.stripStart((String)toParse, null)), (String)"= ");
        if (varNameDelimiterPos == -1) {
            vars.put(toParse, "");
        } else {
            int variableEnd;
            String varName = toParse.substring(0, varNameDelimiterPos);
            boolean shouldSwallowSeparator = toParse.charAt(varNameDelimiterPos) == '=';
            toParse = toParse.substring(varNameDelimiterPos + (shouldSwallowSeparator ? 1 : 0));
            char quotedBy = '\u0000';
            boolean backslash = false;
            for (variableEnd = 0; variableEnd < toParse.length(); ++variableEnd) {
                char lookingAt = toParse.charAt(variableEnd);
                if (backslash) {
                    backslash = false;
                    continue;
                }
                switch (lookingAt) {
                    case '\\': {
                        backslash = quotedBy != '\'' && processBackslashes;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (lookingAt == quotedBy) {
                            quotedBy = '\u0000';
                            break;
                        }
                        if (quotedBy != '\u0000') break;
                        quotedBy = lookingAt;
                    }
                }
                if (!backslash && quotedBy == '\u0000' && Character.isWhitespace(lookingAt)) break;
            }
            String varValue = toParse.substring(0, variableEnd);
            if (quotedBy != '\u0000') {
                varValue = varValue + quotedBy;
            }
            vars.put(varName, varValue);
            toParse = toParse.substring(variableEnd);
            EnvironmentVariableStringUtils.tokeniseVariables(vars, toParse, processBackslashes);
        }
    }
}

