/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.process.DelegatingProcessHandler;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ExternalProcessViaBatchBuilder
extends ExternalProcessBuilder {
    private static final Logger log = Logger.getLogger(ExternalProcessViaBatchBuilder.class);
    private ProcessHandler handler;
    private Iterable<String> commandLine;
    private boolean forceBatch;
    private boolean wrapCommandInQuotesOnWindows = false;

    private static String wrapWithQuotesIfNeeded(String string) {
        if (string.startsWith("'") || string.startsWith("\"") || !string.contains(" ")) {
            return string;
        }
        return "\"" + string + "\"";
    }

    public ExternalProcessViaBatchBuilder forceBatch() {
        this.forceBatch = true;
        return this;
    }

    public ExternalProcessBuilder command(List<String> command) {
        this.commandLine = command;
        return super.command(command);
    }

    public ExternalProcessBuilder handler(ProcessHandler handler) {
        this.handler = handler;
        return super.handler(handler);
    }

    private boolean isCallViaBatchEnabled() {
        boolean containsSpaces = BambooIterables.stream(this.commandLine).anyMatch(i -> i.contains(" "));
        return this.forceBatch || this.isWindows() && containsSpaces;
    }

    public ExternalProcess build() {
        this.convertCallToBatchCallIfNeeded();
        if (this.wrapCommandInQuotesOnWindows && this.isWindows()) {
            List newCommand = BambooIterables.stream(this.commandLine).map(ExternalProcessViaBatchBuilder::wrapWithQuotesIfNeeded).collect(Collectors.toList());
            log.debug((Object)("Override command to " + String.join((CharSequence)" ", newCommand)));
            super.command(newCommand);
        }
        return super.build();
    }

    public ExternalProcessViaBatchBuilder wrapCommandInQuotesOnWindows() {
        this.wrapCommandInQuotesOnWindows = true;
        return this;
    }

    private void convertCallToBatchCallIfNeeded() {
        if (!this.isCallViaBatchEnabled()) {
            return;
        }
        try {
            String command = ExternalProcessViaBatchBuilder.wrapWithQuotesIfNeeded((String)Iterables.get(this.commandLine, (int)0));
            Iterable args = Iterables.skip(this.commandLine, (int)1);
            if (!Iterables.isEmpty((Iterable)args)) {
                command = command + ' ' + Joiner.on((char)' ').join(args);
            }
            if (SystemUtils.LINE_SEPARATOR != null) {
                command = command + SystemUtils.LINE_SEPARATOR;
            }
            File batch = this.writeStringToFile(command);
            super.command((List)ImmutableList.copyOf((Iterable)BambooIterables.concat((Object)batch.getAbsolutePath(), (Iterable)args)));
            super.handler((ProcessHandler)new CleanupOnExitWrapper(batch, this.handler));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create temporary file", e);
        }
    }

    @VisibleForTesting
    File writeStringToFile(String command) throws IOException {
        File batch = BambooFileUtils.safeWriteStringToFile(command, "epb", this.isWindows() ? ".bat" : ".sh", null);
        batch.setReadOnly();
        batch.setExecutable(true);
        return batch;
    }

    @VisibleForTesting
    boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    private static class CleanupOnExitWrapper
    extends DelegatingProcessHandler {
        private final File file;

        public CleanupOnExitWrapper(@NotNull File file, @NotNull ProcessHandler handler) {
            super(handler);
            this.file = file;
        }

        @Override
        public void complete(int exitCode, boolean canceled, ProcessException exception) {
            BambooFiles.deleteLogIfError((Path)this.file.toPath(), (Logger)log);
            super.complete(exitCode, canceled, exception);
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }
    }
}

