/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.bamboo.process.ProcessContextFactory;
import com.atlassian.bamboo.process.ProcessContextImpl;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskProcessCommandDecoratorModuleDescriptor;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.plugin.PluginAccessor;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class ProcessContextFactoryImpl
implements ProcessContextFactory {
    @Inject
    private BuildLoggerManager buildLoggerManager;
    @Inject
    private EnvironmentVariableAccessor environmentVariableAccessor;
    @Inject
    private PluginAccessor pluginAccessor;

    public ProcessContext forTaskContext(@NotNull CommonTaskContext taskContext) {
        return ProcessContextImpl.builder().commonTaskContext(taskContext).environment(this.environmentVariableAccessor.getEnvironment(taskContext)).paths(this.environmentVariableAccessor.getPaths(taskContext)).decorators(this.decorators((TaskIdentifier)taskContext)).build();
    }

    public ProcessContext forCommonContext(@NotNull CommonContext commonContext) {
        return ProcessContextImpl.builder().commonContext(commonContext).buildLogger(this.buildLoggerManager.getLogger(commonContext.getResultKey())).build();
    }

    private List<TaskProcessCommandDecorator> decorators(@NotNull TaskIdentifier taskIdentifier) {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(TaskProcessCommandDecoratorModuleDescriptor.class).stream().filter(BambooPluginUtils.isTaskProcessCommandDecoratorApplicableTo(taskIdentifier)).map(BambooPluginUtils::instantiateModule).collect(Collectors.toList());
    }
}

