/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildKey;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.VariableContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessContextImpl
implements ProcessContext {
    private final BuildLogger buildLogger;
    private final long taskId;
    private final CommonContext commonContext;
    private final Map<String, String> environment;
    private final List<String> paths;
    private final List<TaskProcessCommandDecorator> decorators;
    private static AtomicInteger fakeTaskId = new AtomicInteger(1000000);
    @Nullable
    private final CommonTaskContext commonTaskContext;

    private ProcessContextImpl(BuildLogger buildLogger, long taskId, CommonContext commonContext, Map<String, String> environment, List<String> paths, List<TaskProcessCommandDecorator> decorators, CommonTaskContext commonTaskContext) {
        this.buildLogger = buildLogger;
        this.taskId = taskId;
        this.commonContext = commonContext;
        this.environment = environment;
        this.paths = paths;
        this.decorators = decorators;
        this.commonTaskContext = commonTaskContext;
    }

    @NotNull
    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    @NotNull
    public ResultKey getResultKey() {
        return this.commonContext.getResultKey();
    }

    @NotNull
    public String getJobDisplayName() {
        return this.commonContext.getDisplayName();
    }

    @NotNull
    public String getTaskDescription() {
        return this.commonTaskContext != null ? this.commonTaskContext.getUserDescription() : "";
    }

    @NotNull
    public VariableContext getVariableContext() {
        return this.commonContext.getVariableContext();
    }

    public long getTaskId() {
        return this.taskId;
    }

    @NotNull
    public String getTaskPluginKey() {
        return this.commonTaskContext != null ? this.commonTaskContext.getPluginKey() : "";
    }

    @NotNull
    public CommonContext getCommonContext() {
        return this.commonContext;
    }

    @Nullable
    public CommonTaskContext getTaskContext() {
        return this.commonTaskContext;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @NotNull
    public List<String> getPaths() {
        return this.paths;
    }

    @NotNull
    public BuildKey getBuildKey() {
        return this.commonContext.getBuildKey();
    }

    @NotNull
    public List<String> decorateProcessCommand(@NotNull List<String> command) {
        TaskContext buildTaskContext = (TaskContext)Narrow.downTo((Object)this.commonTaskContext, TaskContext.class);
        if (buildTaskContext != null) {
            for (TaskProcessCommandDecorator decorator : this.decorators) {
                command = decorator.decorate(buildTaskContext, command);
            }
        }
        return command;
    }

    static ProcessContextBuilder builder() {
        return new ProcessContextBuilder();
    }

    static class ProcessContextBuilder {
        private BuildLogger buildLogger;
        private Long taskId;
        private CommonContext commonContext;
        private Map<String, String> environment = Collections.emptyMap();
        private List<String> paths = Collections.emptyList();
        private List<TaskProcessCommandDecorator> decorators = Collections.emptyList();
        @Nullable
        private CommonTaskContext commonTaskContext;
        @Nullable
        private TaskResultBuilder taskResultBuilder;

        ProcessContextBuilder() {
        }

        ProcessContextBuilder buildLogger(BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
            return this;
        }

        ProcessContextBuilder taskId(long taskId) {
            this.taskId = taskId;
            return this;
        }

        ProcessContextBuilder commonTaskContext(CommonTaskContext commonTaskContext) {
            this.commonContext(commonTaskContext.getCommonContext());
            this.commonTaskContext = commonTaskContext;
            this.taskId = commonTaskContext.getId();
            this.buildLogger = commonTaskContext.getBuildLogger();
            return this;
        }

        ProcessContextBuilder commonContext(CommonContext commonContext) {
            this.commonContext = commonContext;
            return this;
        }

        ProcessContextBuilder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        ProcessContextBuilder paths(List<String> paths) {
            this.paths = paths;
            return this;
        }

        ProcessContextBuilder decorators(List<TaskProcessCommandDecorator> decorators) {
            this.decorators = decorators;
            return this;
        }

        ProcessContext build() {
            return new ProcessContextImpl(this.buildLogger, this.taskId != null ? this.taskId : (long)fakeTaskId.getAndIncrement(), this.commonContext, this.environment, this.paths, this.decorators, this.commonTaskContext);
        }
    }
}

