/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.utils.EscapeChars;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class ProcessServiceDockeriser {
    public static final String destDirInDocker = "/tmp";

    static ExternalProcessBuilder dockerise(String containerId, ExternalProcessBuilder epb) throws IOException {
        Path fileToRun = ProcessServiceDockeriser.createFileToRunScript(epb);
        Path copyAndExec = ProcessServiceDockeriser.createCopyAndExecScript(containerId, epb, fileToRun);
        ArrayList<String> dockerisedCommand = new ArrayList<String>();
        dockerisedCommand.add(copyAndExec.toString());
        dockerisedCommand.addAll(epb.getCommand());
        return new ExternalProcessBuilder().command(dockerisedCommand).workingDirectory(SystemUtils.getJavaIoTmpDir());
    }

    private static Path createCopyAndExecScript(String containerId, ExternalProcessBuilder epb, Path fileToRun) throws IOException {
        Path pathToRunInDocker = Paths.get(destDirInDocker, fileToRun.getFileName().toString());
        Path copyAndExec = ProcessServiceDockeriser.createTemporaryFile("runInDocker");
        ArrayList copyAndExecScript = Lists.newArrayList((Object[])new String[]{"#!/bin/sh"});
        copyAndExecScript.add(ProcessServiceDockeriser.getDockerPath() + " cp " + fileToRun + " " + containerId + ":" + pathToRunInDocker);
        copyAndExecScript.add("rm " + fileToRun);
        copyAndExecScript.add(ProcessServiceDockeriser.getDockerPath() + " exec -u root " + containerId + " chown root:root " + pathToRunInDocker);
        copyAndExecScript.add(ProcessServiceDockeriser.getDockerPath() + " exec -u root " + containerId + " chmod 755 " + pathToRunInDocker);
        String variables = epb.getEnv().entrySet().stream().map(kv -> "-e " + EscapeChars.forUnixShell((String)((String)kv.getKey() + "=" + (String)kv.getValue()))).collect(Collectors.joining(" "));
        copyAndExecScript.add(ProcessServiceDockeriser.getDockerPath() + " exec " + variables + " " + containerId + " " + pathToRunInDocker);
        copyAndExecScript.add("RET_CODE=$?");
        copyAndExecScript.add("rm " + copyAndExec);
        copyAndExecScript.add("exit $RET_CODE");
        Files.write(copyAndExec, (Iterable<? extends CharSequence>)copyAndExecScript, StandardCharsets.UTF_8, new OpenOption[0]);
        return copyAndExec;
    }

    private static Path createFileToRunScript(ExternalProcessBuilder epb) throws IOException {
        Path fileToRun = ProcessServiceDockeriser.createTemporaryFile("runInDocker");
        ArrayList toRunInDocker = Lists.newArrayList((Object[])new String[]{"#!/bin/sh"});
        toRunInDocker.add("cd " + EscapeChars.forUnixShell((String)epb.getWorkingDirectory().getAbsolutePath()));
        List paths1 = epb.getPaths();
        if (!paths1.isEmpty()) {
            String pathString = String.join((CharSequence)File.pathSeparator, paths1);
            toRunInDocker.add("export " + EscapeChars.forUnixShell((String)("PATH=" + pathString)) + File.pathSeparator + "${PATH}");
        }
        toRunInDocker.add("umask 000");
        String command = epb.getCommand().stream().map(EscapeChars::forUnixShell).collect(Collectors.joining(" "));
        toRunInDocker.add(command);
        toRunInDocker.add("exit $?");
        Files.write(fileToRun, (Iterable<? extends CharSequence>)toRunInDocker, StandardCharsets.UTF_8, new OpenOption[0]);
        return fileToRun;
    }

    static Path createTemporaryFile(String dockerised) throws IOException {
        SecureTemporaryFiles.FileSpecBuilder builder = SecureTemporaryFiles.builder().setPrefix(dockerised).setSuffix(".sh").setExecutable(true);
        return SecureTemporaryFiles.create(builder.build()).toPath();
    }

    @NotNull
    private static String getDockerPath() {
        return "docker";
    }
}

