/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.BackgroundTaskProcesses;
import com.atlassian.bamboo.process.BackgroundTaskProcessesImpl;
import com.atlassian.bamboo.process.BambooProcessHandler;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ErrorStreamToBuildLoggerOutputHandler;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ExternalProcessViaBatchBuilder;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.bamboo.process.ProcessContextFactory;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.process.ProcessServiceDockeriser;
import com.atlassian.bamboo.process.StreamToBuildLoggerOutputHandler;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildContextImpl;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.utils.process.ClosingInputHandler;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringInputHandler;
import com.atlassian.utils.process.Watchdog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ProcessServiceImpl
implements ProcessService {
    private static final Logger log = Logger.getLogger(ProcessServiceImpl.class);
    private static final Duration VERY_LONG_TIMEOUT = Duration.ofHours(1000L);
    private final CopyOnWriteArrayList<ExternalProcess> externalProcesses = new CopyOnWriteArrayList();
    private final BackgroundTaskProcessesImpl processesOfBackgroundTasks = new BackgroundTaskProcessesImpl();
    private final ProcessMonitor shutdownProcessMonitor = new ProcessMonitor(){

        public void onBeforeStart(ExternalProcess process) {
            ProcessServiceImpl.this.externalProcesses.add(process);
        }

        public void onAfterFinished(ExternalProcess process) {
            ProcessServiceImpl.this.externalProcesses.remove(process);
        }
    };
    private final Thread shutdownHook = new Thread(() -> this.externalProcesses.forEach(Watchdog::cancel), "ProcessService Shutdown Hook");
    @Inject
    private EnvironmentVariableAccessor environmentVariableAccessor;
    @Inject
    private ProcessContextFactory processContextFactory;

    public ProcessServiceImpl() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @NotNull
    private ExternalProcess createProcess(@NotNull ResultKey resultKey, final @NotNull ExternalProcessBuilder processBuilder, final @NotNull BuildLogger buildLogger, final @NotNull ProcessContext processContext) {
        StreamToBuildLoggerOutputHandler stdOut = new StreamToBuildLoggerOutputHandler(buildLogger, resultKey);
        ErrorStreamToBuildLoggerOutputHandler stdErr = new ErrorStreamToBuildLoggerOutputHandler(buildLogger, resultKey);
        InputHandler stdIn = Optional.ofNullable(processBuilder.getInput()).filter(StringUtils::isNotEmpty).map(StringInputHandler::new).orElseGet(() -> processBuilder.isRunWithPowershell() ? new ClosingInputHandler() : null);
        BambooProcessHandler handler = stdIn != null ? new BambooProcessHandler((OutputHandler)stdOut, (OutputHandler)stdErr, stdIn) : new BambooProcessHandler((OutputHandler)stdOut, (OutputHandler)stdErr);
        List command = processBuilder.isRunWithPowershell() ? Lists.newArrayList((Iterable)Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{"powershell", "-NonInteractive", "-ExecutionPolicy", "bypass", "-Command"}), (Iterable)processBuilder.getCommand())) : processBuilder.getCommand();
        com.atlassian.utils.process.ExternalProcessBuilder builder = this.createProcessBuilderInstance(processBuilder).command(command, processBuilder.getWorkingDirectory()).env(processBuilder.getEnv()).env(this.createPathEnvironmentVariableIfNeeded(processBuilder.getPaths())).idleTimeout(VERY_LONG_TIMEOUT.toMillis()).addMonitor(new ProcessMonitor[]{this.shutdownProcessMonitor}).addMonitor(new ProcessMonitor[]{new ProcessMonitor(){

            public void onBeforeStart(ExternalProcess process) {
                LogEntry logEntry = ProcessServiceImpl.this.createProcessLogEntry(processContext, processBuilder);
                log.info((Object)logEntry.getUnstyledLog().replaceAll("\\n", "\n"));
                buildLogger.addBuildLogEntry(logEntry);
                if (log.isDebugEnabled()) {
                    ProcessServiceImpl.this.dumpBuildEnvironmentIntoLog(processContext, process);
                }
            }

            public void onAfterFinished(ExternalProcess process) {
            }
        }}).handler((ProcessHandler)handler).useQuotesInBatArgumentsWorkaround();
        return builder.build();
    }

    private com.atlassian.utils.process.ExternalProcessBuilder createProcessBuilderInstance(ExternalProcessBuilder processBuilder) {
        return processBuilder.isUseWindowsBatFilesForWhitespaceHandling() ? new ExternalProcessViaBatchBuilder() : new com.atlassian.utils.process.ExternalProcessBuilder();
    }

    @NotNull
    public ExternalProcess createExternalProcess(@NotNull ProcessContext processContext, @NotNull ExternalProcessBuilder processBuilder) {
        String path;
        File workingDirectory = processBuilder.getWorkingDirectory();
        Preconditions.checkArgument((workingDirectory != null ? 1 : 0) != 0, (Object)"Working directory for processBuilder must be specified");
        boolean directoryExists = BambooFileUtils.isDirectoryOrLinkToDirectory(workingDirectory);
        Preconditions.checkArgument((boolean)directoryExists, (Object)("The working directory " + workingDirectory + " must exist before executing the process"));
        ResultKey resultKey = processContext.getResultKey();
        BuildLogger buildLogger = processContext.getBuildLogger();
        ExternalProcessBuilder finalProcessBuilder = new ExternalProcessBuilder().env(processContext.getEnvironment()).env(processBuilder.getEnv()).path(processBuilder.getPaths()).path(processContext.getPaths()).workingDirectory(workingDirectory).command(this.processQuotesInCommand(processContext.decorateProcessCommand(processBuilder.getCommand()))).runWithPowershell(processBuilder.isRunWithPowershell()).input(processBuilder.getInput());
        this.environmentVariableAccessor.validateEnvironmentVariables(finalProcessBuilder.getEnv());
        String dockerContainerId = this.getDockerContainerId(processContext, processBuilder);
        if (dockerContainerId != null) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dockerContainerId), (Object)"Container id hasn't been supplied");
            try {
                finalProcessBuilder = ProcessServiceDockeriser.dockerise(dockerContainerId, finalProcessBuilder);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        if ((path = finalProcessBuilder.getCommandExecutable()) != null && !new File(path).exists() && !new File(workingDirectory, path).exists()) {
            buildLogger.addErrorLogEntry("Unable to find executable at " + path + ". Will try to run it anyway.");
        }
        return this.createProcess(resultKey, finalProcessBuilder, buildLogger, processContext);
    }

    private String getDockerContainerId(ProcessContext processContext, ExternalProcessBuilder processBuilder) {
        if (processBuilder.getDockerContainerId() != null) {
            return processBuilder.getDockerContainerId();
        }
        VariableDefinitionContext containerNameVar = (VariableDefinitionContext)processContext.getVariableContext().getEffectiveVariables().get("auto.docker.container.name");
        if (containerNameVar != null) {
            return containerNameVar.getValue();
        }
        return null;
    }

    @NotNull
    public ExternalProcess createExternalProcess(@NotNull CommonTaskContext taskContext, @NotNull ExternalProcessBuilder processBuilder) {
        return this.createExternalProcess(this.processContextFactory.forTaskContext(taskContext), processBuilder);
    }

    @NotNull
    public ExternalProcess executeExternalProcess(@NotNull ProcessContext processContext, @NotNull ExternalProcessBuilder processBuilder) {
        ExternalProcess process = this.createExternalProcess(processContext, processBuilder);
        process.start();
        if (processBuilder.isBackgroundProcess()) {
            this.processesOfBackgroundTasks.add(processContext, process, processBuilder.getCompletionCallback());
        } else {
            process.finish();
            processBuilder.getCompletionCallback().orElse(Runnables.doNothing()).run();
        }
        return process;
    }

    @NotNull
    public ExternalProcess executeExternalProcess(@NotNull CommonTaskContext taskContext, @NotNull ExternalProcessBuilder processBuilder) {
        return this.executeExternalProcess(this.processContextFactory.forTaskContext(taskContext), processBuilder);
    }

    @NotNull
    private Map<String, String> createPathEnvironmentVariableIfNeeded(@NotNull Iterable<String> paths) {
        HashMap<String, String> environment = new HashMap<String, String>();
        if (Iterables.isEmpty(paths)) {
            return environment;
        }
        String pathKey = StringUtils.defaultString((String)SystemProperty.PATH.getKey(), (String)"Path");
        String pathValue = SystemProperty.PATH.getValue("");
        environment.put(pathKey, String.format("%s%s%s", StringUtils.join(paths.iterator(), (String)File.pathSeparator), pathValue.isEmpty() ? "" : File.pathSeparator, pathValue));
        return environment;
    }

    @NotNull
    private LogEntry createProcessLogEntry(@NotNull ProcessContext processContext, @NotNull ExternalProcessBuilder processBuilder) {
        StringBuilder logTextBuilder = new StringBuilder().append(String.format("Beginning to execute external process for build '%s'", processContext.getJobDisplayName())).append("\\n").append(" ... running command line: ").append("\\n");
        String maskedCommand = StringUtils.join((Iterable)processBuilder.getCommand(), (String)" ");
        maskedCommand = PasswordMaskingUtils.maskPossiblePasswordValues((String)maskedCommand, (VariableContext)processContext.getVariableContext());
        logTextBuilder.append(maskedCommand).append("\\n");
        BuildContextImpl buildContext = (BuildContextImpl)Narrow.downTo((Object)processContext.getCommonContext(), BuildContextImpl.class);
        if (buildContext != null) {
            buildContext.getBuildResult().getCustomBuildData().put(String.format("%s.%s.%d", "build.commandline", processContext.getTaskPluginKey(), processContext.getTaskId()), maskedCommand);
        }
        logTextBuilder.append(" ... in: ").append(processBuilder.getWorkingDirectory().getAbsolutePath()).append("\\n");
        Iterable environmentVariables = Iterables.concat(processBuilder.getEnv().entrySet(), this.createPathEnvironmentVariableIfNeeded(processBuilder.getPaths()).entrySet());
        if (!Iterables.isEmpty((Iterable)environmentVariables)) {
            logTextBuilder.append(" ... using extra environment variables: ").append("\\n");
            for (Map.Entry entry : environmentVariables) {
                String value = (String)entry.getValue();
                if (PasswordMaskingUtils.shouldBeMasked((String)((String)entry.getKey()))) {
                    value = "********";
                }
                logTextBuilder.append((String)entry.getKey()).append("=").append(value).append("\\n");
            }
        }
        return new CommandLogEntry(logTextBuilder.toString());
    }

    private void dumpBuildEnvironmentIntoLog(@NotNull ProcessContext processContext, @NotNull ExternalProcess externalProcess) {
        BuildLogger buildLogger = processContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Outputting build debug information");
        buildLogger.addBuildLogEntry("Displaying command line elements");
        buildLogger.addBuildLogEntry(externalProcess.getCommandLine());
        buildLogger.addBuildLogEntry("End of build debug information");
    }

    private List<String> processQuotesInCommand(@NotNull List<String> command) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return command;
        }
        return Lists.transform(command, BambooStringUtils::stripFullyEnclosingQuotes);
    }

    public static void shutdown() {
        com.atlassian.utils.process.ExternalProcessBuilder.getExternalProcessFactory().shutdown();
    }

    @VisibleForTesting
    void removeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    public BackgroundTaskProcesses getBackgroundProcesses() {
        return this.processesOfBackgroundTasks;
    }
}

