/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StreamToBuildLoggerOutputHandler
extends BaseOutputHandler {
    private static final Logger log = Logger.getLogger(StreamToBuildLoggerOutputHandler.class);
    private static final Pattern MAVEN_DOWNLOAD_PATTERN = Pattern.compile("^[0-9]*/[0-9]*K$");
    private static final Pattern MAVEN_UPLOAD_PATTERN = Pattern.compile("^[0-9]*/\\?$");
    protected final BuildLogger buildLogger;
    protected final ResultKey resultKey;
    private final boolean filterDownloadStatusMessages;

    public StreamToBuildLoggerOutputHandler(BuildLogger buildLogger, ResultKey resultKey) {
        this(buildLogger, resultKey, false);
    }

    public StreamToBuildLoggerOutputHandler(BuildLogger buildLogger, ResultKey resultKey, boolean filterDownloadStatusMessages) {
        this.buildLogger = buildLogger;
        this.resultKey = resultKey;
        this.filterDownloadStatusMessages = filterDownloadStatusMessages;
    }

    public void process(InputStream inputStream) throws ProcessException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.resetWatchdog();
                this.log(line);
            }
            log.debug((Object)"Ending pump");
        }
        catch (InterruptedIOException e) {
            log.debug((Object)("Pump interrupted " + Thread.currentThread().isInterrupted()), (Throwable)e);
        }
        catch (IOException e) {
            log.info((Object)("Failed to pump input stream. " + this.resultKey + " may already have finished"), (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
        catch (Throwable e) {
            log.info((Object)"Failed to pump input stream. Internal error", e);
            throw new ProcessException(e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected void log(@NotNull String line) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.resultKey + "] " + line));
        }
        if (!(this.buildLogger == null || this.filterDownloadStatusMessages && this.isDownloadStatusMessage(line))) {
            this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry(line));
        }
    }

    private boolean isDownloadStatusMessage(@NotNull String line) {
        return MAVEN_DOWNLOAD_PATTERN.matcher(line).matches() || MAVEN_UPLOAD_PATTERN.matcher(line).matches();
    }
}

