/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.PermissionsServiceUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooAclHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.TransactionStatus;

abstract class AbstractProjectPermissionsService {
    private final Function<String, ManagedLock> lockFactory = ManagedLocks.weakManagedLockFactory();
    private final TransactionAndHibernateTemplate hibernateTemplate;
    private final BambooAclHelper aclHelper;
    private final ProjectManager projectManager;
    private final BambooPermissionManager bambooPermissionManager;
    private final BambooUserManager bambooUserManager;
    private final Collection<BambooPermission> supportedPermissions;
    private final Multimap<BambooPermission, BambooPermission> permissionDependencies;

    public AbstractProjectPermissionsService(TransactionAndHibernateTemplate hibernateTemplate, BambooAclHelper aclHelper, ProjectManager projectManage, BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager, Collection<BambooPermission> supportedPermissions, Multimap<BambooPermission, BambooPermission> permissionDependencies) {
        this.hibernateTemplate = hibernateTemplate;
        this.aclHelper = aclHelper;
        this.projectManager = projectManage;
        this.bambooPermissionManager = bambooPermissionManager;
        this.bambooUserManager = bambooUserManager;
        this.supportedPermissions = ImmutableSet.copyOf(supportedPermissions);
        this.permissionDependencies = ImmutableMultimap.copyOf(permissionDependencies);
    }

    abstract MutableAcl getAcl(Project var1);

    Iterable<String> listUsersWithPermissionsForProject(@NotNull String projectKey) {
        Project project = this.validateProject(projectKey);
        this.hasPermissionForProject(project);
        MutableAcl projectAcl = this.getAcl(project);
        return this.aclHelper.listUsersWithPermissions((Acl)projectAcl, this.supportedPermissions());
    }

    List<BambooPermission> getUserPermissionsForProject(@NotNull String projectKey, @NotNull String username) {
        Project project = this.validateProject(projectKey);
        this.hasPermissionForProject(project);
        User user = this.validateUser(username);
        MutableAcl projectAcl = this.getAcl(project);
        return this.aclHelper.getUserPermissions((Acl)projectAcl, user.getName(), this.supportedPermissions());
    }

    boolean addUserPermissionsToProject(@NotNull String projectKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            User user = this.validateUser(username);
            this.validatePermissionsForProject(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getUserPermissionsForProject(projectKey, user.getName()), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToProject(projectKey, permissionKeysToAdd);
        });
    }

    boolean removeUserPermissionsFromProject(@NotNull String projectKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            User user = this.validateUser(username);
            this.validateDependenciesAfterRevoking(this.getUserPermissionsForProject(projectKey, user.getName()), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromProject(projectKey, permissionKeysToRemove);
        });
    }

    Iterable<String> listGroupsWithPermissionsForProject(@NotNull String projectKey) {
        Project project = this.validateProject(projectKey);
        this.hasPermissionForProject(project);
        MutableAcl projectAcl = this.getAcl(project);
        return this.aclHelper.listGroupsWithPermissions((Acl)projectAcl, this.supportedPermissions());
    }

    List<BambooPermission> getGroupPermissionsForProject(@NotNull String projectKey, @NotNull String groupName) {
        Project project = this.validateProject(projectKey);
        this.hasPermissionForProject(project);
        Group group = this.validateGroup(groupName);
        MutableAcl projectAcl = this.getAcl(project);
        return this.aclHelper.getGroupPermissions((Acl)projectAcl, group.getName(), this.supportedPermissions());
    }

    boolean addGroupPermissionsToProject(@NotNull String projectKey, @NotNull String groupName, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            Group group = this.validateGroup(groupName);
            this.validatePermissionsForProject(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getGroupPermissionsForProject(projectKey, group.getName()), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(group.getName(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToProject(projectKey, permissionKeysToAdd);
        });
    }

    boolean removeGroupPermissionsFromProject(@NotNull String projectKey, @NotNull String groupName, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            Group group = this.validateGroup(groupName);
            this.validateDependenciesAfterRevoking(this.getGroupPermissionsForProject(projectKey, group.getName()), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(group.getName(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromProject(projectKey, permissionKeysToRemove);
        });
    }

    List<BambooPermission> getLoggedInPermissionsForProject(@NotNull String projectKey) {
        Project project = this.validateProject(projectKey);
        this.hasPermissionForProject(project);
        MutableAcl projectAcl = this.getAcl(project);
        return this.aclHelper.getLoggedInPermissions((Acl)projectAcl, this.supportedPermissions());
    }

    boolean addLoggedInPermissionsToProject(@NotNull String projectKey, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            this.validatePermissionsForProject(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getLoggedInPermissionsForProject(projectKey), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToProject(projectKey, permissionKeysToAdd);
        });
    }

    boolean removeLoggedInPermissionsFromProject(@NotNull String projectKey, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            this.validateDependenciesAfterRevoking(this.getLoggedInPermissionsForProject(projectKey), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromProject(projectKey, permissionKeysToRemove);
        });
    }

    List<BambooPermission> getAnonymousPermissionsForProject(@NotNull String projectKey) {
        Project project = this.validateProject(projectKey);
        this.hasPermissionForProject(project);
        MutableAcl projectAcl = this.getAcl(project);
        return this.aclHelper.getAnonymousPermissions((Acl)projectAcl, this.supportedPermissions());
    }

    boolean addAnonymousPermissionsToProject(@NotNull String projectKey) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            String permission = BambooAclUpdateHelper.createRolePermissionKey(Authority.ANONYMOUS.getAuthority(), BambooPermission.READ.getName());
            return this.addPermissionKeysToProject(projectKey, Collections.singletonList(permission));
        });
    }

    boolean removeAnonymousPermissionsFromProject(@NotNull String projectKey) {
        return this.withExclusiveLock(projectKey, () -> {
            Project project = this.validateProject(projectKey);
            this.hasPermissionForProject(project);
            String permission = BambooAclUpdateHelper.createRolePermissionKey(Authority.ANONYMOUS.getAuthority(), BambooPermission.READ.getName());
            return this.removePermissionKeysFromProject(projectKey, Collections.singletonList(permission));
        });
    }

    @NotNull
    Collection<BambooPermission> supportedPermissions() {
        return this.supportedPermissions;
    }

    @NotNull
    Collection<BambooPermission> permissionDependencies(@NotNull BambooPermission permission) {
        return PermissionsServiceUtils.extractDependencies(this.permissionDependencies, this.supportedPermissions, permission);
    }

    private void hasPermissionForProject(Project project) {
        if (!this.bambooPermissionManager.hasProjectPermission((Permission)BambooPermission.ADMINISTRATION, project.getKey())) {
            throw new AccessDeniedException(String.format("Not allowed to access project: %s permissions", project.getKey()));
        }
    }

    private Project validateProject(String projectKey) {
        Project project = this.projectManager.getProjectByKey(projectKey);
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)String.format("Project: %s does not exist", projectKey));
        return project;
    }

    private User validateUser(String username) {
        return PermissionsServiceUtils.validateUser(username, this.bambooUserManager);
    }

    private Group validateGroup(String groupName) {
        return PermissionsServiceUtils.validateGroup(groupName, this.bambooUserManager);
    }

    private void validatePermissionsForProject(List<BambooPermission> permissions) throws AccessDeniedException {
        PermissionsServiceUtils.validatePermissions(permissions, this.supportedPermissions(), "project");
    }

    private void validateDependenciesAfterGranting(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToAdd) {
        Sets.SetView effectivePermissions = Sets.union(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToAdd));
        PermissionsServiceUtils.validateDependenciesAfterGranting((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private void validateDependenciesAfterRevoking(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToRemove) {
        Sets.SetView effectivePermissions = Sets.difference(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToRemove));
        PermissionsServiceUtils.validateDependenciesAfterRevoking((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private boolean addPermissionKeysToProject(@NotNull String projectKey, @NotNull List<String> permissionKeysToAdd) {
        Project project = this.validateProject(projectKey);
        MutableAcl acl = this.getAcl(project);
        return this.aclHelper.addPermissionKeys(acl, permissionKeysToAdd);
    }

    private boolean removePermissionKeysFromProject(@NotNull String projectKey, @NotNull List<String> permissionKeysToRemove) {
        Project project = this.validateProject(projectKey);
        MutableAcl acl = this.getAcl(project);
        return this.aclHelper.removePermissionKeys(acl, permissionKeysToRemove);
    }

    private <T> T withExclusiveLock(String projectKey, Supplier<T> supplier) {
        return (T)this.lockFactory.apply(projectKey).withLock(() -> this.hibernateTemplate.execute(arg_0 -> AbstractProjectPermissionsService.lambda$null$14((Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ Object lambda$null$14(Supplier supplier, TransactionStatus transactionStatus) {
        return supplier.get();
    }
}

