/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.hibernate.HibernateBambooEntityWithOid;
import com.atlassian.bamboo.labels.LabelFunctions;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="PROJECT")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class DefaultProject
extends HibernateBambooEntityWithOid
implements Project {
    private String key;
    protected String name;
    protected String description;
    private List<Labelling> labellings;
    private boolean markedForDeletion;
    private List<Plan> allPlans = Collections.emptyList();

    public DefaultProject(@NotNull String key, @NotNull String name, @NotNull String description) {
        this.setKey(key);
        this.setName(name);
        this.setDescription(description);
    }

    public DefaultProject() {
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public void setKey(@NotNull String key) {
        this.key = BambooInterners.intern((String)key);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = BambooInterners.intern((String)name);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = BambooInterners.intern((String)description);
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    @NotNull
    private Collection<Plan> getAllPlans() {
        return this.allPlans;
    }

    @NotNull
    private <T extends ImmutablePlan> List<T> getPlansOfClass(Class<T> planClass) {
        return this.allPlans.stream().filter(BambooPredicates::isNotDeleted).flatMap(OptionalNarrow.down(planClass)).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getCurrentStatus() {
        return DefaultProject.getCurrentStatusFromPlans(this.getPlansOfClass(TopLevelPlan.class));
    }

    public static String getCurrentStatusFromPlans(Collection<? extends ImmutableTopLevelPlan> plans) {
        boolean successExist = false;
        for (ImmutableTopLevelPlan plan : Iterables.filter(plans, p -> !p.isSuspendedFromBuilding())) {
            String currentStatus = plan.getCurrentStatus();
            if (currentStatus.equals("current")) {
                return "current";
            }
            if (currentStatus.equals("fail")) {
                return "fail";
            }
            if (!currentStatus.equals("success")) continue;
            successExist = true;
        }
        if (successExist) {
            return "success";
        }
        return "none";
    }

    private void setAllPlans(@NotNull List<Plan> allPlans) {
        this.allPlans = allPlans;
    }

    public List<Labelling> getLabellings() {
        return this.labellings;
    }

    public List<Labelling> getRelatedLabellings() {
        return this.getLabellings().stream().filter(LabelFunctions::isProjectRelated).collect(Collectors.toCollection(ArrayList::new));
    }

    public void setLabellings(List<Labelling> labellings) {
        this.labellings = labellings;
    }

    public int hashCode() {
        return new HashCodeBuilder(89, 11).append((Object)this.getKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultProject)) {
            return false;
        }
        DefaultProject rhs = (DefaultProject)((Object)o);
        return new EqualsBuilder().append((Object)this.getKey(), (Object)rhs.getKey()).isEquals();
    }

    public int compareTo(Object obj) {
        DefaultProject o = (DefaultProject)((Object)obj);
        return new CompareToBuilder().append((Object)this.getKey(), (Object)o.getKey()).toComparison();
    }
}

