/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.Comparators;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultProjectManager
implements ProjectManager {
    private final BambooAclUpdateHelper aclUpdateHelper;
    private final ProjectDao projectDao;
    private final HibernateMutableAclService aclService;

    public DefaultProjectManager(BambooAclUpdateHelper aclUpdateHelper, HibernateMutableAclService aclService, ProjectDao projectDao) {
        this.aclUpdateHelper = aclUpdateHelper;
        this.aclService = aclService;
        this.projectDao = projectDao;
    }

    @NotNull
    public Project createProject(@NotNull String key, @NotNull String name, @NotNull String description) {
        return new DefaultProject(key, name, description);
    }

    public Project createAndSaveProject(@NotNull String key, @NotNull String name, @Nullable String description, boolean grantAllUsersAccess) {
        Project project = this.createProject(key, name, StringUtils.defaultString((String)description));
        this.internalSaveProject(project, grantAllUsersAccess);
        return project;
    }

    @NotNull
    public Set<Project> getProjects() {
        return this.projectDao.findAll().stream().filter(BambooPredicates::isNotDeleted).collect(Collectors.toCollection(HashSet::new));
    }

    @NotNull
    public List<Project> getNonEmptyProjects() {
        return this.projectDao.getNonEmptyProjects();
    }

    @NotNull
    public List<Project> getEmptyProjects() {
        return this.projectDao.getEmptyProjects();
    }

    @NotNull
    public List<Project> getSortedProjects() {
        return Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy(this.getProjects());
    }

    @NotNull
    public Set<Project> getAllProjects() {
        return new HashSet<Project>(this.projectDao.findAll());
    }

    @NotNull
    public Number getProjectCount() {
        return this.projectDao.count();
    }

    public Number getNonDeletedProjectCount() {
        return this.projectDao.countNonDeleted();
    }

    public Project getProjectByKey(@NotNull String key) {
        return this.projectDao.getProjectByKey(key);
    }

    @Nullable
    public Project getProjectById(long id) {
        return this.projectDao.findById(id);
    }

    @Nullable
    public Project getProjectByOid(@NotNull BambooEntityOid oid) {
        return (Project)this.projectDao.findByOid(oid, DefaultProject.class);
    }

    public Project getProjectByName(@NotNull String projectName) {
        return this.projectDao.getProjectByName(projectName);
    }

    public boolean isExistingProjectName(@NotNull String projectName) {
        return this.projectDao.isExistingProjectName(projectName);
    }

    public boolean isExistingProjectKey(@NotNull String projectKey) {
        return this.projectDao.isExistingProjectKey(projectKey);
    }

    public void saveProject(@NotNull Project project) {
        this.internalSaveProject(project, true);
    }

    private void internalSaveProject(@NotNull Project project, boolean grantAllUsersAccessForNewProject) {
        this.projectDao.save((BambooObject)project);
        this.createAclIfNecessary(new HibernateObjectIdentityImpl(project), (List<BambooPermission>)ImmutableList.of((Object)BambooPermission.READ, (Object)BambooPermission.CREATE, (Object)BambooPermission.ADMINISTRATION), grantAllUsersAccessForNewProject);
        this.createAclIfNecessary(new HibernateObjectIdentityImpl(new ProjectPlanPermissions((ProjectIdentifier)project)), Collections.emptyList(), false);
    }

    public void deleteProject(@NotNull Project project) {
        this.aclService.deleteAcl((ObjectIdentity)new HibernateObjectIdentityImpl(project), false);
        this.aclService.deleteAcl((ObjectIdentity)new HibernateObjectIdentityImpl(new ProjectPlanPermissions((ProjectIdentifier)project)), false);
        this.projectDao.delete(project);
    }

    @NotNull
    public Collection<Project> getAllProjectsMarkedForDeletion() {
        return this.projectDao.getAllProjectsMarkedForDeletion();
    }

    private void createAclIfNecessary(@NotNull ObjectIdentity objectIdentity, @NotNull List<BambooPermission> defaultPermissions, boolean grantReadPermissionForAnonymousAndLoggedinUsers) {
        try {
            this.aclService.readMutableAclById(objectIdentity);
        }
        catch (NotFoundException e) {
            MutableAcl acl = this.aclService.createAcl(objectIdentity);
            this.aclUpdateHelper.addPermissionsToAclForCurrentUser(acl, defaultPermissions);
            if (grantReadPermissionForAnonymousAndLoggedinUsers) {
                this.aclUpdateHelper.addReadPermissionForAnonymousAndLoggedinUsers(acl);
            }
            this.aclService.updateAcl(acl);
        }
    }
}

