/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.project.AbstractProjectPermissionsService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.project.ProjectPermissionsService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooAclHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.BambooUserManager;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultProjectPermissionsService
implements ProjectPermissionsService {
    private static final Collection<BambooPermission> SUPPORTED_PERMISSIONS = ImmutableSet.builder().add((Object)BambooPermission.READ).add((Object)BambooPermission.CREATE).add((Object)BambooPermission.ADMINISTRATION).build();
    private static final Multimap<BambooPermission, BambooPermission> PERMISSION_DEPENDENCIES = ImmutableMultimap.builder().put((Object)BambooPermission.CREATE, (Object)BambooPermission.READ).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.CREATE).build();
    private final HibernateMutableAclService aclService;
    private final AbstractProjectPermissionsService delegate;

    @Autowired
    public DefaultProjectPermissionsService(HibernateMutableAclService aclService, TransactionAndHibernateTemplate hibernateTemplate, BambooAclHelper aclHelper, ProjectManager projectManager, BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager) {
        this.aclService = aclService;
        this.delegate = new AbstractProjectPermissionsService(hibernateTemplate, aclHelper, projectManager, bambooPermissionManager, bambooUserManager, SUPPORTED_PERMISSIONS, PERMISSION_DEPENDENCIES){

            @Override
            MutableAcl getAcl(Project project) {
                return DefaultProjectPermissionsService.this.getAclForProject(project);
            }
        };
    }

    @NotNull
    private MutableAcl getAclForProject(@NotNull Project project) {
        return this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl(project));
    }

    @NotNull
    public Iterable<String> listUsersWithPermissionsForProject(@NotNull String projectKey) {
        return this.delegate.listUsersWithPermissionsForProject(projectKey);
    }

    @NotNull
    public List<BambooPermission> getUserPermissionsForProject(@NotNull String projectKey, @NotNull String username) {
        return this.delegate.getUserPermissionsForProject(projectKey, username);
    }

    public boolean addUserPermissionsToProject(@NotNull String projectKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.delegate.addUserPermissionsToProject(projectKey, username, permissionsToAdd);
    }

    public boolean removeUserPermissionsFromProject(@NotNull String projectKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.delegate.removeUserPermissionsFromProject(projectKey, username, permissionsToRemove);
    }

    @NotNull
    public Iterable<String> listGroupsWithPermissionsForProject(@NotNull String projectKey) {
        return this.delegate.listGroupsWithPermissionsForProject(projectKey);
    }

    @NotNull
    public List<BambooPermission> getGroupPermissionsForProject(@NotNull String projectKey, @NotNull String group) {
        return this.delegate.getGroupPermissionsForProject(projectKey, group);
    }

    public boolean addGroupPermissionsToProject(@NotNull String projectKey, @NotNull String group, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.delegate.addGroupPermissionsToProject(projectKey, group, permissionsToAdd);
    }

    public boolean removeGroupPermissionsFromProject(@NotNull String projectKey, @NotNull String group, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.delegate.removeGroupPermissionsFromProject(projectKey, group, permissionsToRemove);
    }

    @NotNull
    public List<BambooPermission> getLoggedInPermissionsForProject(@NotNull String projectKey) {
        return this.delegate.getLoggedInPermissionsForProject(projectKey);
    }

    public boolean addLoggedInPermissionsToProject(@NotNull String projectKey, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.delegate.addLoggedInPermissionsToProject(projectKey, permissionsToAdd);
    }

    public boolean removeLoggedInPermissionsFromProject(@NotNull String projectKey, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.delegate.removeLoggedInPermissionsFromProject(projectKey, permissionsToRemove);
    }

    @NotNull
    public Collection<BambooPermission> supportedPermissions() {
        return this.delegate.supportedPermissions();
    }

    @NotNull
    public Collection<BambooPermission> permissionDependencies(@NotNull BambooPermission permission) {
        return this.delegate.permissionDependencies(permission);
    }

    public List<BambooPermission> getAnonymousPermissions(@NotNull String projectKey) {
        return this.delegate.getAnonymousPermissionsForProject(projectKey);
    }

    public boolean addAnonymousPermission(@NotNull String projectKey) {
        return this.delegate.addAnonymousPermissionsToProject(projectKey);
    }

    public boolean removeAnonymousPermission(@NotNull String projectKey) {
        return this.delegate.removeAnonymousPermissionsFromProject(projectKey);
    }
}

