/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.project.AbstractProjectPermissionsService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.project.ProjectPlanPermissionsService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooAclHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.BambooUserManager;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultProjectPlanPermissionsService
implements ProjectPlanPermissionsService {
    private static final Collection<BambooPermission> SUPPORTED_PERMISSIONS = ImmutableSet.of((Object)BambooPermission.READ, (Object)BambooPermission.WRITE, (Object)BambooPermission.BUILD, (Object)BambooPermission.CLONE, (Object)BambooPermission.ADMINISTRATION);
    private static final Multimap<BambooPermission, BambooPermission> PERMISSION_DEPENDENCIES = ImmutableMultimap.builder().put((Object)BambooPermission.WRITE, (Object)BambooPermission.READ).put((Object)BambooPermission.BUILD, (Object)BambooPermission.READ).put((Object)BambooPermission.CLONE, (Object)BambooPermission.READ).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.WRITE).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.BUILD).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.CLONE).build();
    private final HibernateMutableAclService aclService;
    private final AbstractProjectPermissionsService delegate;

    @Autowired
    public DefaultProjectPlanPermissionsService(HibernateMutableAclService aclService, TransactionAndHibernateTemplate hibernateTemplate, BambooAclHelper aclHelper, ProjectManager projectManage, BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager) {
        this.aclService = aclService;
        this.delegate = new AbstractProjectPermissionsService(hibernateTemplate, aclHelper, projectManage, bambooPermissionManager, bambooUserManager, SUPPORTED_PERMISSIONS, PERMISSION_DEPENDENCIES){

            @Override
            MutableAcl getAcl(Project project) {
                return DefaultProjectPlanPermissionsService.this.getAclForProjectPlanPermissions(project);
            }
        };
    }

    @NotNull
    private MutableAcl getAclForProjectPlanPermissions(@NotNull Project project) {
        return this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl(new ProjectPlanPermissions((ProjectIdentifier)project)));
    }

    @NotNull
    public Iterable<String> listUsersWithPermissionsForProjectPlan(@NotNull String projectKey) {
        return this.delegate.listUsersWithPermissionsForProject(projectKey);
    }

    @NotNull
    public List<BambooPermission> getUserPermissionsForProjectPlan(@NotNull String projectKey, @NotNull String username) {
        return this.delegate.getUserPermissionsForProject(projectKey, username);
    }

    public boolean addUserPermissionsToProjectPlan(@NotNull String projectKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.delegate.addUserPermissionsToProject(projectKey, username, permissionsToAdd);
    }

    public boolean removeUserPermissionsFromProjectPlan(@NotNull String projectKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.delegate.removeUserPermissionsFromProject(projectKey, username, permissionsToRemove);
    }

    @NotNull
    public Iterable<String> listGroupsWithPermissionsForProjectPlan(@NotNull String projectKey) {
        return this.delegate.listGroupsWithPermissionsForProject(projectKey);
    }

    @NotNull
    public List<BambooPermission> getGroupPermissionsForProjectPlan(@NotNull String projectKey, @NotNull String group) {
        return this.delegate.getGroupPermissionsForProject(projectKey, group);
    }

    public boolean addGroupPermissionsToProjectPlan(@NotNull String projectKey, @NotNull String group, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.delegate.addGroupPermissionsToProject(projectKey, group, permissionsToAdd);
    }

    public boolean removeGroupPermissionsFromProjectPlan(@NotNull String projectKey, @NotNull String group, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.delegate.removeGroupPermissionsFromProject(projectKey, group, permissionsToRemove);
    }

    @NotNull
    public List<BambooPermission> getLoggedInPermissionsForProjectPlan(@NotNull String projectKey) {
        return this.delegate.getLoggedInPermissionsForProject(projectKey);
    }

    public boolean addLoggedInPermissionsToProjectPlan(@NotNull String projectKey, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.delegate.addLoggedInPermissionsToProject(projectKey, permissionsToAdd);
    }

    public boolean removeLoggedInPermissionsFromProjectPlan(@NotNull String projectKey, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.delegate.removeLoggedInPermissionsFromProject(projectKey, permissionsToRemove);
    }

    @NotNull
    public List<BambooPermission> getAnonymousPermissionsForProjectPlan(@NotNull String projectKey) {
        return this.delegate.getAnonymousPermissionsForProject(projectKey);
    }

    public boolean addAnonymousPermissionsToPlan(@NotNull String projectKey) {
        return this.delegate.addAnonymousPermissionsToProject(projectKey);
    }

    public boolean removeAnonymousPermissionsFromPlan(@NotNull String projectKey) {
        return this.delegate.removeAnonymousPermissionsFromProject(projectKey);
    }

    @NotNull
    public Collection<BambooPermission> supportedPermissions() {
        return this.delegate.supportedPermissions();
    }

    @NotNull
    public Collection<BambooPermission> permissionDependencies(@NotNull BambooPermission permission) {
        return this.delegate.permissionDependencies(permission);
    }
}

