/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.event.ProjectCreatedEvent;
import com.atlassian.bamboo.event.ProjectDeletedEvent;
import com.atlassian.bamboo.event.ProjectUpdatedEvent;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.validation.ValidationFunction;
import com.atlassian.bamboo.validation.ValidationService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.TextProvider;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectConfigurationServiceImpl
implements ProjectConfigurationService {
    public static final String PROJECT_KEY_FIELD = (String)BambooConstantUtils.preventInlining((Object)"projectKey");
    public static final String PROJECT_NAME_FIELD = (String)BambooConstantUtils.preventInlining((Object)"projectName");
    public static final String PROJECT_DESCRIPTION_FIELD = (String)BambooConstantUtils.preventInlining((Object)"projectDescription");
    private final PlanManager planManager;
    private final ProjectManager projectManager;
    private final TextProvider textProvider;
    private final ValidationService validationService;
    private final AuditLogService auditLogService;
    private final EventPublisher eventPublisher;

    @Autowired
    public ProjectConfigurationServiceImpl(PlanManager planManager, ProjectManager projectManager, TextProvider textProvider, ValidationService validationService, AuditLogService auditLogService, EventPublisher eventPublisher) {
        this.planManager = planManager;
        this.projectManager = projectManager;
        this.textProvider = textProvider;
        this.validationService = validationService;
        this.auditLogService = auditLogService;
        this.eventPublisher = eventPublisher;
    }

    @NotNull
    public ErrorCollection validateProjectForCreation(@Nullable String projectKey, @Nullable String projectName, @Nullable String projectDescription) {
        return this.validateProjectForCreation(PROJECT_KEY_FIELD, projectKey, PROJECT_NAME_FIELD, projectName, PROJECT_DESCRIPTION_FIELD, projectDescription);
    }

    @NotNull
    public ErrorCollection validateProjectForCreation(@NotNull String projectKeyField, @Nullable String projectKey, @NotNull String projectNameField, @Nullable String projectName, @NotNull String projectDescriptionField, @Nullable String projectDescription) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorCollection(this.validationService.validateProjectKey(projectKeyField, projectKey, new ValidationFunction[0]));
        errorCollection.addErrorCollection(this.validationService.validateName(projectNameField, ValidationService.ValidationType.PROJECT.getErrorPrefix(), projectName));
        errorCollection.addErrorCollection(this.validationService.validateDescription(projectDescriptionField, projectDescription));
        if (!errorCollection.hasAnyErrors()) {
            if (this.projectManager.isExistingProjectName(projectName)) {
                errorCollection.addError(projectNameField, this.textProvider.getText("project.name.exists", Collections.singletonList(projectName)));
            }
            if (this.projectManager.isExistingProjectKey(projectKey)) {
                errorCollection.addError(projectKeyField, this.textProvider.getText("project.key.exists", Collections.singletonList(projectKey)));
            }
        }
        return errorCollection;
    }

    @NotNull
    public Project createProject(@NotNull String projectKey, @NotNull String projectName, @Nullable String projectDescription, boolean grantAllUsersReadAccess) throws WebValidationException {
        BambooValidationUtils.checkErrors(this.validateProjectForCreation(projectKey, projectName, projectDescription));
        Project project = this.projectManager.createAndSaveProject(projectKey, projectName, projectDescription, grantAllUsersReadAccess);
        String oldAuditLogValue = null;
        String newAuditLogValue = this.projectAuditLogInfo(projectName, projectDescription);
        this.auditLogService.log("Project created: " + projectKey, oldAuditLogValue, newAuditLogValue, null);
        this.eventPublisher.publish((Object)new ProjectCreatedEvent(projectKey));
        return project;
    }

    @NotNull
    public ErrorCollection validateProjectForUpdate(@NotNull String projectKey, @Nullable String projectName, @Nullable String projectDescription) {
        return this.validateProjectForUpdate(projectKey, PROJECT_NAME_FIELD, projectName, PROJECT_DESCRIPTION_FIELD, projectDescription);
    }

    @NotNull
    public ErrorCollection validateProjectForUpdate(@NotNull String projectKey, @NotNull String projectNameField, @Nullable String projectName, @NotNull String projectDescriptionField, @Nullable String projectDescription) {
        Project projectByName;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorCollection(this.validationService.validateName(projectNameField, ValidationService.ValidationType.PROJECT.getErrorPrefix(), projectName));
        errorCollection.addErrorCollection(this.validationService.validateDescription(projectDescriptionField, projectDescription));
        if (!errorCollection.hasAnyErrors() && (projectByName = this.projectManager.getProjectByName(projectName)) != null && !projectByName.getKey().equals(projectKey)) {
            errorCollection.addError(projectNameField, this.textProvider.getText("project.name.exists", Collections.singletonList(projectName)));
        }
        return errorCollection;
    }

    public void updateProject(@NotNull Project project, @NotNull String projectName, @Nullable String projectDescription) throws WebValidationException {
        BambooValidationUtils.checkErrors(this.validateProjectForUpdate(project.getKey(), projectName, projectDescription));
        String oldAuditLogValue = this.projectAuditLogInfo(project.getName(), project.getDescription());
        String newAuditLogValue = this.projectAuditLogInfo(projectName, projectDescription);
        project.setName(projectName);
        project.setDescription(projectDescription);
        this.projectManager.saveProject(project);
        this.planManager.triggerConfigUpdatedEventsForPlansInProject(project);
        this.auditLogService.log("Project updated: " + project.getKey(), oldAuditLogValue, newAuditLogValue, null);
        this.eventPublisher.publish((Object)new ProjectUpdatedEvent(project.getKey()));
    }

    public void markProjectForDeletion(@NotNull Project project) {
        if (this.planManager.getPlanCount((ProjectIdentifier)project) != 0) {
            throw new IllegalArgumentException(this.textProvider.getText("project.deletion.error.not.empty"));
        }
        String oldAuditLogValue = this.projectAuditLogInfo(project.getName(), project.getDescription());
        long projectId = project.getId();
        String projectKey = project.getKey();
        project.setMarkedForDeletion(true);
        this.projectManager.saveProject(project);
        this.auditLogService.log("Project deleted: " + projectKey, oldAuditLogValue, null, null);
        this.eventPublisher.publish((Object)new ProjectDeletedEvent(projectKey, projectId));
    }

    private String projectAuditLogInfo(@NotNull String name, @Nullable String description) {
        StringBuilder stringBuilder = new StringBuilder("Name: \"").append(name);
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            stringBuilder.append("\", Description: \"").append(description).append("\"");
        }
        return stringBuilder.toString();
    }
}

