/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quartz;

import com.atlassian.bamboo.util.BambooSpringUtils;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Lazy;

public class AutowiringJobFactory
extends SimpleJobFactory
implements JobFactory {
    private static final Logger log = Logger.getLogger(AutowiringJobFactory.class);
    @Lazy
    @Inject
    private AutowireCapableBeanFactory beanFactory;

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Job job = super.newJob(bundle, scheduler);
        BambooSpringUtils.autowireComponent(this.beanFactory, job);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Triggering job: " + job));
        }
        return job;
    }
}

