/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quartz;

import io.atlassian.util.concurrent.CopyOnWriteMap;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.listeners.TriggerListenerSupport;

public class PreventJobExecutionUntilCompletedTriggerListener
extends TriggerListenerSupport {
    private static final Logger log = Logger.getLogger(PreventJobExecutionUntilCompletedTriggerListener.class);
    public static final TriggerListener INSTANCE = new PreventJobExecutionUntilCompletedTriggerListener();
    private final ConcurrentMap<Trigger, Map<JobDetail, JobExecutionContext>> executionInProgress = CopyOnWriteMap.builder().newHashMap();
    private final Function<Trigger, ManagedLock> triggerLock = ManagedLocks.weakManagedLockFactory();

    public String getName() {
        return PreventJobExecutionUntilCompletedTriggerListener.class.getName();
    }

    public void triggerComplete(final Trigger trigger, final JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        this.triggerLock.apply(trigger).withLock(new Runnable(){

            @Override
            public void run() {
                Map runningJobs = (Map)PreventJobExecutionUntilCompletedTriggerListener.this.executionInProgress.get(trigger);
                if (runningJobs != null) {
                    JobDetail currentJobDetail = context.getJobDetail();
                    JobExecutionContext currentExecutionContext = (JobExecutionContext)runningJobs.get(currentJobDetail);
                    if (currentExecutionContext == null) {
                        log.error((Object)String.format("Attempt to complete job execution [%s] triggered by [%s] but no execution for job [%s] has ever been fired", context.toString(), trigger.toString(), currentJobDetail.toString()));
                    } else if (currentExecutionContext != context) {
                        log.error((Object)String.format("Attempt to complete job execution [%s] triggered by [%s] but different execution [%s] has been fired for job [%s]", context.toString(), trigger.toString(), currentExecutionContext.toString(), currentJobDetail.toString()));
                    } else {
                        runningJobs.remove(currentJobDetail);
                    }
                } else {
                    log.error((Object)String.format("Attempt to complete job execution [%s] triggered by [%s] but this trigger has never been fired", context.toString(), trigger.toString()));
                }
            }
        });
    }

    public void triggerFired(final Trigger trigger, final JobExecutionContext context) {
        this.triggerLock.apply(trigger).withLock(new Runnable(){

            @Override
            public void run() {
                PreventJobExecutionUntilCompletedTriggerListener.this.executionInProgress.putIfAbsent(trigger, new HashMap());
                Map runningJobs = (Map)PreventJobExecutionUntilCompletedTriggerListener.this.executionInProgress.get(trigger);
                runningJobs.putIfAbsent(context.getJobDetail(), context);
            }
        });
    }

    public boolean vetoJobExecution(final Trigger trigger, final JobExecutionContext context) {
        try {
            return (Boolean)this.triggerLock.apply(trigger).withLock((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Map runningJobs = (Map)PreventJobExecutionUntilCompletedTriggerListener.this.executionInProgress.get(trigger);
                    if (runningJobs != null) {
                        JobDetail contextJobDetail = context.getJobDetail();
                        JobExecutionContext currentExecutionContext = (JobExecutionContext)runningJobs.get(contextJobDetail);
                        if (currentExecutionContext == context) {
                            return false;
                        }
                        if (currentExecutionContext == null) {
                            log.error((Object)String.format("Job execution [%s] triggered by [%s] has been vetoed - no execution for job [%s] has ever been fired", context.toString(), trigger.toString(), contextJobDetail.toString()));
                        } else {
                            log.warn((Object)String.format("Job execution [%s] triggered by [%s] has been vetoed - previous job execution [%s] has not yet completed", context.toString(), trigger.toString(), currentExecutionContext.toString()));
                        }
                    } else {
                        log.info((Object)String.format("Job execution [%s] triggered by [%s] has been vetoed - trigger has never been fired", context.toString(), trigger.toString()));
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            log.error((Object)String.format("Job execution [%s] triggered by [%s] has been vetoed - unexpected problem [%s]", context.toString(), trigger.toString(), e.getMessage()));
            return true;
        }
    }
}

