/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quartz;

import com.atlassian.bamboo.event.ServerStartedEvent;
import com.atlassian.bamboo.performance.ActionIdentifier;
import com.atlassian.bamboo.performance.ActionType;
import com.atlassian.bamboo.performance.PerformanceStatsService;
import com.atlassian.event.api.EventListener;
import com.google.common.base.Throwables;
import java.util.Date;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.listeners.JobListenerSupport;

public class QuartzJobDurationListener
extends JobListenerSupport {
    private static final Logger log = Logger.getLogger(QuartzJobDurationListener.class);
    private static final String LISTENER_NAME = "Job execution time listener";
    @Inject
    private Scheduler scheduler;
    @Inject
    private PerformanceStatsService performanceStatsService;

    @PreDestroy
    public void deregisterListener() {
        this.unregisterQuartzListener();
    }

    @EventListener
    public void onApplicationStarted(ServerStartedEvent event) {
        this.registerQuartzListener();
    }

    private void unregisterQuartzListener() {
        try {
            this.scheduler.getListenerManager().removeJobListener(this.getName());
        }
        catch (SchedulerException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void registerQuartzListener() {
        try {
            this.scheduler.getListenerManager().addJobListener((JobListener)this);
        }
        catch (SchedulerException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public String getName() {
        return LISTENER_NAME;
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Job jobInstance = context.getJobInstance();
        if (jobException == null) {
            Date fireTime = context.getFireTime();
            long duration = Math.max(0L, System.currentTimeMillis() - fireTime.getTime());
            this.performanceStatsService.recordExecution(new ActionIdentifier(ActionType.QUARTZ, jobInstance.getClass().getName()), duration);
        } else {
            log.debug((Object)("Job " + jobInstance + " completed with exception: " + jobException));
        }
    }
}

