/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter;

import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRule;
import com.atlassian.core.bean.EntityObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="QUICK_FILTERS")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class QuickFilterEntity
extends EntityObject
implements QuickFilter {
    private String name;
    private int position = -1;
    private List<QuickFilterRule> rules = new ArrayList<QuickFilterRule>();

    private QuickFilterEntity() {
    }

    private QuickFilterEntity(@NotNull QuickFilterEntity from) {
        this(from.getName());
        this.setId(from.getId());
        this.setPosition(from.getPosition());
        this.setCreationDate(from.getCreationDate());
        this.setLastModificationDate(from.getLastModificationDate());
    }

    public QuickFilterEntity(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public QuickFilterEntity copy() {
        QuickFilterEntity quickFilterEntity = new QuickFilterEntity(this);
        quickFilterEntity.setRules(this.getRules().stream().map(rule -> rule.copy((QuickFilter)quickFilterEntity)).collect(Collectors.toCollection(ArrayList::new)));
        return quickFilterEntity;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @NotNull
    public List<QuickFilterRule> getRules() {
        return this.rules;
    }

    public void setRules(@NotNull List<QuickFilterRule> rules) {
        this.rules = rules;
    }
}

