/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterDao;
import com.atlassian.bamboo.quickfilter.QuickFilterManager;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRule;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleTypeModuleDescriptor;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleTypeUnsafeCodeDecorator;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.validation.ValidationService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class QuickFilterManagerImpl
implements QuickFilterManager {
    private static final Logger log = Logger.getLogger(QuickFilterManagerImpl.class);
    private final ManagedLock.ReadWrite lock = ManagedLocks.manageReadWrite((ReadWriteLock)new ReentrantReadWriteLock());
    @Inject
    private PluginAccessor pluginAccessor;
    @Inject
    private QuickFilterDao quickFilterDao;
    @Inject
    private TextProvider textProvider;
    @Inject
    private ValidationService validationService;
    @Inject
    private AuditLogService auditLogService;

    @NotNull
    public List<QuickFilter> findAll() {
        return (List)this.lock.read().withLock(() -> {
            List filters = this.quickFilterDao.findAll();
            return filters.stream().map(QuickFilter::copy).collect(Collectors.toCollection(ArrayList::new));
        });
    }

    @Nullable
    public QuickFilter findById(long id) {
        return (QuickFilter)this.lock.read().withLock(() -> {
            QuickFilter filter = this.quickFilterDao.findById(id);
            return filter != null ? filter.copy() : null;
        });
    }

    @NotNull
    public ErrorCollection validate(@NotNull QuickFilter quickFilter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ErrorCollection nameErrors = this.validationService.validateName("name", "quick.filters.admin.error", quickFilter.getName());
        if (!nameErrors.hasAnyErrors()) {
            this.lock.read().withLock(() -> this.lambda$validate$2(quickFilter, (ErrorCollection)errors));
        }
        errors.addErrorCollection(nameErrors);
        return errors;
    }

    public void create(@NotNull QuickFilter quickFilter) {
        this.lock.write().withLock(() -> this.quickFilterDao.create(quickFilter));
        this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.filter.added", (List)ImmutableList.of((Object)quickFilter.getName(), (Object)quickFilter.getPosition())));
    }

    public void update(@NotNull QuickFilter quickFilter, int previousPosition) {
        AtomicReference nameFromDb = new AtomicReference();
        AtomicReference positionFromDb = new AtomicReference();
        this.lock.write().withLock(() -> {
            QuickFilter quickFilterFromDb = this.quickFilterDao.findById(quickFilter.getId());
            if (quickFilterFromDb != null) {
                nameFromDb.set(quickFilterFromDb.getName());
                positionFromDb.set(quickFilterFromDb.getPosition());
            }
            this.quickFilterDao.update(quickFilter, previousPosition);
        });
        if (nameFromDb.get() != null && !((String)nameFromDb.get()).equals(quickFilter.getName())) {
            this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.filter.renamed", (List)ImmutableList.of(nameFromDb.get(), (Object)quickFilter.getName())));
        }
        if (positionFromDb.get() != null && ((Integer)positionFromDb.get()).intValue() != quickFilter.getPosition()) {
            this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.filter.moved", (List)ImmutableList.of((Object)quickFilter.getName(), positionFromDb.get(), (Object)quickFilter.getPosition())));
        }
    }

    public void delete(@NotNull QuickFilter quickFilter) {
        this.lock.write().withLock(() -> this.quickFilterDao.delete((BambooObject)quickFilter));
        this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.filter.removed", Collections.singletonList(quickFilter.getName())));
    }

    public <T extends ImmutableTopLevelPlan> Iterable<T> filter(@NotNull Iterable<T> plans, @NotNull QuickFilter quickFilter) {
        Iterable filteredPlans = plans;
        for (QuickFilterRule rule : quickFilter.getRules()) {
            QuickFilterRuleTypeModuleDescriptor moduleDescriptor = (QuickFilterRuleTypeModuleDescriptor)((Object)Narrow.downTo((Object)this.pluginAccessor.getEnabledPluginModule(rule.getPluginKey()), QuickFilterRuleTypeModuleDescriptor.class));
            if (moduleDescriptor != null) {
                QuickFilterRuleType ruleType = (QuickFilterRuleType)moduleDescriptor.getModule();
                if (ruleType != null) {
                    QuickFilterRuleTypeUnsafeCodeDecorator wrappedRuleType = new QuickFilterRuleTypeUnsafeCodeDecorator(ruleType);
                    Map ruleConfiguration = rule.getConfiguration();
                    filteredPlans = Iterables.filter(filteredPlans, plan -> wrappedRuleType.matches(ruleConfiguration, (ImmutableTopLevelPlan)plan));
                    continue;
                }
                log.info((Object)("Couldn't instantiate module of " + ((Object)((Object)moduleDescriptor)).getClass().getName()));
                continue;
            }
            log.info((Object)("Couldn't find plugin module by key " + rule.getPluginKey()));
        }
        return filteredPlans;
    }

    private /* synthetic */ void lambda$validate$2(QuickFilter quickFilter, ErrorCollection errors) {
        QuickFilter otherByName = this.quickFilterDao.findByName(quickFilter.getName());
        if (otherByName != null && otherByName.getId() != quickFilter.getId()) {
            errors.addError("name", this.textProvider.getText("quick.filters.admin.error.name.not.unique"));
        }
    }
}

