/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter;

import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterManager;
import com.atlassian.bamboo.quickfilter.UserActiveQuickFilterService;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.user.User;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class UserActiveQuickFilterServiceImpl
implements UserActiveQuickFilterService {
    private static final Logger log = Logger.getLogger(UserActiveQuickFilterServiceImpl.class);
    private static final UserProperty CFG_ACTIVE_QUICK_FILTERS = new UserProperty("activeQuickFilters", 5);
    private static final UserProperty CFG_VISIBLE_QUICK_FILTERS = new UserProperty("visibleQuickFilters", 6);
    @Inject
    private BambooUserManager bambooUserManager;
    @Inject
    private QuickFilterManager quickFilterManager;

    @NotNull
    public List<QuickFilter> getVisibleQuickFilters(@NotNull User user) {
        Optional<Set<Long>> visibleFilterIds = this.getFilterIdsForUser(user, CFG_VISIBLE_QUICK_FILTERS);
        if (visibleFilterIds.isPresent()) {
            return this.quickFilterManager.findAll().stream().filter(quickFilter -> ((Set)visibleFilterIds.get()).contains(quickFilter.getId())).collect(Collectors.toList());
        }
        return this.quickFilterManager.findAll();
    }

    public synchronized void setVisibleQuickFilters(@NotNull User user, @NotNull Iterable<Long> quickFilterIds) {
        ImmutableSet visibleFilterIds = ImmutableSet.copyOf(quickFilterIds);
        this.saveFilterIdsForUser(user, CFG_VISIBLE_QUICK_FILTERS, (Iterable<Long>)visibleFilterIds);
        Set activeFilterIds = this.getFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS).orElseGet(HashSet::new);
        this.saveFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS, BambooIterables.filter((Iterable)activeFilterIds, ((Set)visibleFilterIds)::contains));
    }

    @NotNull
    public List<QuickFilter> getActiveQuickFilters(@NotNull User user) {
        Set activeFilterIds = this.getFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS).orElseGet(HashSet::new);
        return this.quickFilterManager.findAll().stream().filter(quickFilter -> activeFilterIds.contains(quickFilter.getId())).collect(Collectors.toList());
    }

    public synchronized void activateQuickFilter(@NotNull User user, long quickFilterId) {
        Optional<Set<Long>> visibleFilterIds = this.getFilterIdsForUser(user, CFG_VISIBLE_QUICK_FILTERS);
        if (!visibleFilterIds.isPresent() || visibleFilterIds.get().contains(quickFilterId)) {
            Set activeFilterIds = this.getFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS).orElseGet(HashSet::new);
            activeFilterIds.add(quickFilterId);
            this.saveFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS, activeFilterIds);
        }
    }

    public synchronized void deactivateQuickFilter(@NotNull User user, long quickFilterId) {
        Set activeFilterIds = this.getFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS).orElseGet(HashSet::new);
        activeFilterIds.remove(quickFilterId);
        this.saveFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS, activeFilterIds);
    }

    public synchronized void deactivateAllQuickFilters(@NotNull User user) {
        this.saveFilterIdsForUser(user, CFG_ACTIVE_QUICK_FILTERS, new HashSet<Long>());
    }

    @NotNull
    private Optional<Set<Long>> getFilterIdsForUser(@NotNull User user, @NotNull UserProperty userProperty) {
        PropertySet userPropertySet = this.bambooUserManager.getPropertySet(user);
        String filterIds = userProperty.get(userPropertySet);
        if (filterIds != null) {
            try {
                return Optional.of(Pattern.compile(",").splitAsStream(filterIds).map(Long::parseLong).collect(Collectors.toCollection(HashSet::new)));
            }
            catch (Exception e) {
                log.info((Object)String.format("Couldn't obtain filter ids for user '%s' from user property '%s'", user.getName(), userProperty), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private void saveFilterIdsForUser(@NotNull User user, @NotNull UserProperty userProperty, @NotNull Iterable<Long> filterIds) {
        userProperty.set(this.bambooUserManager.getPropertySet(user), Joiner.on((String)",").join(filterIds));
    }

    private static class UserProperty {
        private final String key;
        private final int type;

        private UserProperty(@NotNull String key, int type) {
            Preconditions.checkArgument((type == 6 || type == 5 ? 1 : 0) != 0, (Object)("Unsupported type of user property " + key));
            this.key = key;
            this.type = type;
        }

        @Nullable
        private String get(@NotNull PropertySet propertySet) {
            switch (this.type) {
                case 5: {
                    return propertySet.getString(this.key);
                }
                case 6: {
                    return propertySet.getText(this.key);
                }
            }
            throw new UnsupportedOperationException("Unsupported type of user property " + this.key);
        }

        private void set(@NotNull PropertySet propertySet, @Nullable String value) {
            switch (this.type) {
                case 5: {
                    propertySet.setString(this.key, value);
                    break;
                }
                case 6: {
                    propertySet.setText(this.key, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type of user property " + this.key);
                }
            }
        }

        public String toString() {
            return this.key;
        }
    }
}

