/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule;

import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRule;
import com.atlassian.core.bean.EntityObject;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="QUICK_FILTER_RULES")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class QuickFilterRuleEntity
extends EntityObject
implements QuickFilterRule {
    private QuickFilter quickFilter;
    private String pluginKey;
    private String name;
    private String serializedConfig;

    private QuickFilterRuleEntity() {
    }

    private QuickFilterRuleEntity(@NotNull QuickFilterRuleEntity from, @NotNull QuickFilter quickFilter) {
        this(quickFilter, from.getPluginKey(), from.getName());
        this.setId(from.getId());
        this.setConfiguration(from.getConfiguration());
        this.setCreationDate(from.getCreationDate());
        this.setLastModificationDate(from.getLastModificationDate());
    }

    private QuickFilterRuleEntity(@NotNull QuickFilterRuleEntity from) {
        this(from, from.getQuickFilter().copy());
    }

    public QuickFilterRuleEntity(@NotNull QuickFilter quickFilter, @NotNull String pluginKey, @NotNull String name) {
        this.quickFilter = quickFilter;
        this.pluginKey = pluginKey;
        this.name = name;
    }

    @NotNull
    public QuickFilterRuleEntity copy() {
        return new QuickFilterRuleEntity(this);
    }

    @NotNull
    public QuickFilterRuleEntity copy(@NotNull QuickFilter quickFilter) {
        return new QuickFilterRuleEntity(this, quickFilter);
    }

    @NotNull
    public QuickFilter getQuickFilter() {
        return this.quickFilter;
    }

    public void setQuickFilter(@NotNull QuickFilter quickFilter) {
        this.quickFilter = quickFilter;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    public void setPluginKey(@NotNull String pluginKey) {
        this.pluginKey = pluginKey;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public Map<String, Object> getConfiguration() {
        return StringUtils.isNotBlank((CharSequence)this.serializedConfig) ? new HashMap((Map)new Gson().fromJson(this.serializedConfig, Map.class)) : new HashMap();
    }

    public void setConfiguration(@NotNull Map<String, Object> configuration) {
        this.serializedConfig = new Gson().toJson(configuration);
    }

    public String getSerializedConfig() {
        return this.serializedConfig;
    }

    public void setSerializedConfig(String serializedConfig) {
        this.serializedConfig = serializedConfig;
    }
}

