/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRule;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleDao;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleManager;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFilterRuleManagerImpl
implements QuickFilterRuleManager {
    @Inject
    private AuditLogService auditLogService;
    @Inject
    private TextProvider textProvider;
    @Inject
    private QuickFilterRuleDao quickFilterRuleDao;

    @Nullable
    public QuickFilterRule findById(long id) {
        QuickFilterRule quickFilterRule = this.quickFilterRuleDao.findById(id);
        return quickFilterRule != null ? quickFilterRule.copy() : null;
    }

    public void save(@NotNull QuickFilterRule rule) {
        QuickFilterRule oldRule = this.quickFilterRuleDao.findById(rule.getId());
        String oldName = oldRule != null ? oldRule.getName() : "";
        HashMap oldConfiguration = oldRule != null ? new HashMap(oldRule.getConfiguration()) : new HashMap();
        Set oldConfigurationEntries = oldConfiguration.entrySet();
        this.quickFilterRuleDao.save((BambooObject)rule);
        if (oldRule == null) {
            this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.rule.created", (List)ImmutableList.of((Object)rule.getName(), (Object)rule.getQuickFilter().getName())));
        } else if (!oldName.equals(rule.getName())) {
            this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.rule.renamed", (List)ImmutableList.of((Object)oldName, (Object)rule.getQuickFilter().getName(), (Object)rule.getName())));
        }
        Set newConfigurationEntries = rule.getConfiguration().entrySet();
        for (Map.Entry entry : Sets.difference(newConfigurationEntries, oldConfigurationEntries)) {
            if (oldConfiguration.keySet().contains(entry.getKey())) {
                this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.rule.configuration.changed", (List)ImmutableList.of((Object)rule.getName(), (Object)rule.getQuickFilter().getName(), entry.getKey(), oldConfiguration.get(entry.getKey()), entry.getValue())));
                continue;
            }
            this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.rule.configuration.added", (List)ImmutableList.of((Object)rule.getName(), (Object)rule.getQuickFilter().getName(), entry.getKey(), entry.getValue())));
        }
        for (String key : Sets.difference(oldConfiguration.keySet(), rule.getConfiguration().keySet())) {
            this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.rule.configuration.removed", (List)ImmutableList.of((Object)rule.getName(), (Object)rule.getQuickFilter().getName(), (Object)key)));
        }
    }

    public void delete(@NotNull QuickFilterRule rule) {
        this.quickFilterRuleDao.delete((BambooObject)rule);
        this.auditLogService.log(this.textProvider.getText("quick.filters.audit.log.rule.removed", (List)ImmutableList.of((Object)rule.getName(), (Object)rule.getQuickFilter().getName())));
    }
}

