/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule.plugin;

import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.quickfilter.rule.AbstractQuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HasLabelRuleType
extends AbstractQuickFilterRuleType
implements QuickFilterRuleType {
    @VisibleForTesting
    static final String CFG_SELECTED_LABEL_NAMES = "selectedLabelNames";
    private static final String CFG_ALL_PLAN_LABELS = "allPlanLabels";
    private final TextProvider textProvider;
    private final LabelManager labelManager;

    @Inject
    public HasLabelRuleType(@NotNull TemplateRenderer templateRenderer, @NotNull TextProvider textProvider, @NotNull LabelManager labelManager) {
        super(templateRenderer);
        this.textProvider = textProvider;
        this.labelManager = labelManager;
    }

    @NotNull
    public String getName() {
        return this.textProvider.getText("quick.filters.rules.plugin.hasLabel.name");
    }

    @Nullable
    public String getDescription() {
        return this.textProvider.getText("quick.filters.rules.plugin.hasLabel.description");
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return Collections.singleton(CFG_SELECTED_LABEL_NAMES);
    }

    public void addDefaults(@NotNull Map<String, Object> configuration) {
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, Object> configuration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (ConfigUtils.getPropertyAsList(configuration, (String)CFG_SELECTED_LABEL_NAMES, String.class).isEmpty()) {
            errorCollection.addError(CFG_SELECTED_LABEL_NAMES, this.textProvider.getText("quick.filters.rules.plugin.hasLabel.selectedLabels.empty"));
        }
        return errorCollection;
    }

    public boolean matches(@NotNull Map<String, Object> configuration, @NotNull ImmutableTopLevelPlan plan) {
        HashSet selectedLabelNames = new HashSet(ConfigUtils.getPropertyAsList(configuration, (String)CFG_SELECTED_LABEL_NAMES, String.class));
        return plan.getLabelNames().stream().anyMatch(selectedLabelNames::contains);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> configuration, @NotNull Map<String, Object> context) {
        context.put(CFG_ALL_PLAN_LABELS, this.labelManager.getAllPlanLabels());
    }
}

