/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule.plugin;

import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.quickfilter.rule.AbstractQuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InProjectRuleType
extends AbstractQuickFilterRuleType
implements QuickFilterRuleType {
    @VisibleForTesting
    static final String CFG_SELECTED_PROJECT_KEYS = "selectedProjectKeys";
    private static final String CFG_EXISTING_PROJECTS = "existingProjects";
    private static final String CFG_EXISTING_PROJECTS_JSON = "existingProjectsJson";
    private static final String ADD_PROJECT_FIELD = "addProjectTextField";
    private final TextProvider textProvider;
    private final ProjectManager projectManager;

    @Inject
    public InProjectRuleType(@NotNull TemplateRenderer templateRenderer, @NotNull TextProvider textProvider, @NotNull ProjectManager projectManager) {
        super(templateRenderer);
        this.textProvider = textProvider;
        this.projectManager = projectManager;
    }

    @NotNull
    public String getName() {
        return this.textProvider.getText("quick.filters.rules.plugin.inProject.name");
    }

    @Nullable
    public String getDescription() {
        return this.textProvider.getText("quick.filters.rules.plugin.inProject.description");
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return Collections.singleton(CFG_SELECTED_PROJECT_KEYS);
    }

    public void addDefaults(@NotNull Map<String, Object> configuration) {
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, Object> configuration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (ConfigUtils.getPropertyAsList(configuration, (String)CFG_SELECTED_PROJECT_KEYS, String.class).isEmpty()) {
            errorCollection.addError(ADD_PROJECT_FIELD, this.textProvider.getText("quick.filters.rules.plugin.inProject.selectedProjects.empty"));
        }
        return errorCollection;
    }

    public boolean matches(@NotNull Map<String, Object> configuration, @NotNull ImmutableTopLevelPlan plan) {
        HashSet selectedKeys = new HashSet(ConfigUtils.getPropertyAsList(configuration, (String)CFG_SELECTED_PROJECT_KEYS, String.class));
        return selectedKeys.contains(plan.getProject().getKey());
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> configuration, @NotNull Map<String, Object> context) {
        List<Project> selectedProjects = this.getSelectedProjects(configuration);
        context.put(CFG_EXISTING_PROJECTS, selectedProjects);
        context.put(CFG_EXISTING_PROJECTS_JSON, this.toJsonArray(selectedProjects));
    }

    @NotNull
    private List<Project> getSelectedProjects(@NotNull Map<String, Object> configuration) {
        return ConfigUtils.getPropertyAsList(configuration, (String)CFG_SELECTED_PROJECT_KEYS, String.class).stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectByKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private JSONObject toJsonObject(@NotNull Project project) {
        try {
            return new JSONObject().put("id", (Object)project.getKey()).put("projectName", (Object)project.getName());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private JSONArray toJsonArray(@NotNull List<Project> projects) {
        JSONArray jsonArray = new JSONArray();
        projects.stream().map(this::toJsonObject).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray;
    }
}

