/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule.plugin;

import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.quickfilter.rule.AbstractQuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastExecutionDateRuleType
extends AbstractQuickFilterRuleType
implements QuickFilterRuleType {
    @VisibleForTesting
    static final String CFG_PERIOD = "timePeriod";
    @VisibleForTesting
    static final String CFG_PERIOD_UNIT = "timePeriodUnit";
    private static final String CFG_ALLOWED_PERIOD_UNITS = "allowedPeriodUnits";
    @VisibleForTesting
    static final String PERIOD_UNIT_MINUTES = "minutes";
    @VisibleForTesting
    static final String PERIOD_UNIT_HOURS = "hours";
    @VisibleForTesting
    static final String PERIOD_UNIT_DAYS = "days";
    @VisibleForTesting
    static final String PERIOD_UNIT_WEEKS = "weeks";
    private static final List<String> ALLOWED_PERIOD_UNITS = ImmutableList.of((Object)"minutes", (Object)"hours", (Object)"days", (Object)"weeks");
    private final TextProvider textProvider;

    @Inject
    protected LastExecutionDateRuleType(@NotNull TemplateRenderer templateRenderer, @NotNull TextProvider textProvider) {
        super(templateRenderer);
        this.textProvider = textProvider;
    }

    @NotNull
    public String getName() {
        return this.textProvider.getText("quick.filters.rules.plugin.lastExecutionDate.name");
    }

    @Nullable
    public String getDescription() {
        return this.textProvider.getText("quick.filters.rules.plugin.lastExecutionDate.description");
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return ImmutableSet.of((Object)CFG_PERIOD, (Object)CFG_PERIOD_UNIT);
    }

    public void addDefaults(@NotNull Map<String, Object> configuration) {
        configuration.put(CFG_PERIOD, 1);
        configuration.put(CFG_PERIOD_UNIT, PERIOD_UNIT_DAYS);
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, Object> configuration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!configuration.containsKey(CFG_PERIOD)) {
            errorCollection.addError(CFG_PERIOD, this.textProvider.getText("quick.filters.rules.plugin.lastExecutionDate.period.error.required"));
        } else if (!NumberUtils.isPositiveInteger((String)((String)configuration.get(CFG_PERIOD)))) {
            errorCollection.addError(CFG_PERIOD, this.textProvider.getText("quick.filters.rules.plugin.lastExecutionDate.period.error.invalid"));
        }
        String periodUnit = configuration.getOrDefault(CFG_PERIOD_UNIT, null);
        if (StringUtils.isEmpty((CharSequence)periodUnit)) {
            errorCollection.addError(CFG_PERIOD_UNIT, this.textProvider.getText("quick.filters.rules.plugin.lastExecutionDate.periodUnit.error.required"));
        } else if (ALLOWED_PERIOD_UNITS.stream().noneMatch(periodUnit::equals)) {
            errorCollection.addError(CFG_PERIOD_UNIT, this.textProvider.getText("quick.filters.rules.plugin.lastExecutionDate.periodUnit.error.invalid", Collections.singletonList(periodUnit)));
        }
        return errorCollection;
    }

    public boolean matches(@NotNull Map<String, Object> configuration, @NotNull ImmutableTopLevelPlan plan) {
        Duration duration = this.getDuration(configuration);
        ZonedDateTime minimumDate = ZonedDateTime.now().minus(duration);
        return Optional.ofNullable(plan.getLatestResultsSummary()).map(ImmutableResultsSummary::getBuildCompletedDate).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault())).map(minimumDate::isBefore).orElse(false);
    }

    @Override
    protected void populateContextForEdit(@NotNull Map<String, Object> configuration, @NotNull Map<String, Object> context) {
        context.put(CFG_ALLOWED_PERIOD_UNITS, ALLOWED_PERIOD_UNITS);
    }

    @NotNull
    private Duration getDuration(@NotNull Map<String, Object> configuration) {
        String periodUnit;
        int period = Integer.parseInt((String)configuration.get(CFG_PERIOD));
        switch (periodUnit = (String)configuration.get(CFG_PERIOD_UNIT)) {
            case "minutes": {
                return Duration.ofMinutes(period);
            }
            case "hours": {
                return Duration.ofHours(period);
            }
            case "days": {
                return Duration.ofDays(period);
            }
            case "weeks": {
                return Duration.ofDays(period * 7);
            }
        }
        throw new IllegalStateException("Unknown period unit: " + periodUnit);
    }
}

