/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule.plugin;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.quickfilter.rule.AbstractQuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import io.atlassian.util.concurrent.Lazy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastResultStatusRuleType
extends AbstractQuickFilterRuleType
implements QuickFilterRuleType {
    @VisibleForTesting
    static final String CFG_STATUS = "quick.filters.rules.plugin.lastResultStatus.status";
    private static final String CFG_ALLOWED_STATUSES = "allowedStatuses";
    private final TextProvider textProvider;
    private final Supplier<Map<String, String>> allowedStatuses;

    @Inject
    public LastResultStatusRuleType(@NotNull TemplateRenderer templateRenderer, @NotNull TextProvider textProvider) {
        super(templateRenderer);
        this.textProvider = textProvider;
        this.allowedStatuses = Lazy.supplier(() -> Arrays.stream(BuildState.values()).collect(Collectors.toMap(LastResultStatusRuleType::getStatus, buildState -> textProvider.getText("build.buildState." + buildState.name()))));
    }

    @NotNull
    public String getName() {
        return this.textProvider.getText("quick.filters.rules.plugin.lastResultStatus.name");
    }

    @Nullable
    public String getDescription() {
        return this.textProvider.getText("quick.filters.rules.plugin.lastResultStatus.description");
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return Collections.singleton(CFG_STATUS);
    }

    public void addDefaults(@NotNull Map<String, Object> configuration) {
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, Object> configuration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        List<String> statuses = this.getStatuses(configuration);
        if (statuses.isEmpty()) {
            errorCollection.addError(CFG_STATUS, this.textProvider.getText("quick.filters.rules.plugin.lastResultStatus.status.error.required"));
        }
        for (String status : statuses) {
            if (this.allowedStatuses.get().containsKey(status)) continue;
            errorCollection.addError(CFG_STATUS, this.textProvider.getText("quick.filters.rules.plugin.lastResultStatus.status.error.invalid", Collections.singletonList(status)));
        }
        return errorCollection;
    }

    public boolean matches(@NotNull Map<String, Object> configuration, @NotNull ImmutableTopLevelPlan plan) {
        List<String> statuses = this.getStatuses(configuration);
        ImmutableResultsSummary lastResultSummary = plan.getLatestResultsSummary();
        return lastResultSummary != null && statuses.stream().map(BuildState::getInstance).anyMatch(state -> Objects.equals(state, lastResultSummary.getBuildState()));
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> configuration, @NotNull Map<String, Object> context) {
        context.put(CFG_ALLOWED_STATUSES, this.allowedStatuses.get());
    }

    @NotNull
    private List<String> getStatuses(@NotNull Map<String, Object> configuration) {
        ArrayList<String> result = new ArrayList<String>();
        if (configuration.containsKey(CFG_STATUS)) {
            Object statusData = configuration.get(CFG_STATUS);
            if (statusData instanceof String) {
                Splitter.on((String)",").split((CharSequence)((String)statusData)).forEach(result::add);
            } else if (statusData instanceof Collection) {
                ((Collection)statusData).stream().map(Object::toString).forEach(result::add);
            }
        }
        return result;
    }

    @NotNull
    @VisibleForTesting
    static String getStatus(@NotNull BuildState buildState) {
        return buildState.getState().toLowerCase(Locale.US);
    }
}

