/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule.plugin;

import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.quickfilter.rule.AbstractQuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameMatcherRuleType
extends AbstractQuickFilterRuleType
implements QuickFilterRuleType {
    @VisibleForTesting
    static final String CFG_REGEX = "quick.filters.rules.plugin.nameMatcher.regex";
    private final TextProvider textProvider;

    @Inject
    protected NameMatcherRuleType(@NotNull TemplateRenderer templateRenderer, @NotNull TextProvider textProvider) {
        super(templateRenderer);
        this.textProvider = textProvider;
    }

    @NotNull
    public String getName() {
        return this.textProvider.getText("quick.filters.rules.plugin.nameMatcher.name");
    }

    @Nullable
    public String getDescription() {
        return this.textProvider.getText("quick.filters.rules.plugin.nameMatcher.description");
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return Collections.singleton(CFG_REGEX);
    }

    public void addDefaults(@NotNull Map<String, Object> configuration) {
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, Object> configuration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String regularExpression = configuration.getOrDefault(CFG_REGEX, null);
        if (StringUtils.isEmpty((CharSequence)regularExpression)) {
            errorCollection.addError(CFG_REGEX, this.textProvider.getText("quick.filters.rules.plugin.nameMatcher.regex.error.required"));
        } else {
            try {
                Pattern.compile(regularExpression);
            }
            catch (PatternSyntaxException e) {
                errorCollection.addError(CFG_REGEX, this.textProvider.getText("quick.filters.rules.plugin.nameMatcher.regex.error.invalid"));
            }
        }
        return errorCollection;
    }

    public boolean matches(@NotNull Map<String, Object> configuration, @NotNull ImmutableTopLevelPlan plan) {
        String regexPattern = (String)configuration.get(CFG_REGEX);
        boolean hasUpperCase = regexPattern.chars().anyMatch(Character::isUpperCase);
        int flags = hasUpperCase ? 0 : 2;
        Pattern pattern = Pattern.compile(regexPattern, flags);
        Matcher matcher = pattern.matcher(plan.getBuildName());
        return matcher.find();
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> configuration, @NotNull Map<String, Object> context) {
    }
}

