/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule.plugin;

import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.quickfilter.rule.AbstractQuickFilterRuleType;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleType;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspensionStatusRuleType
extends AbstractQuickFilterRuleType
implements QuickFilterRuleType {
    @VisibleForTesting
    static final String CFG_STATUS = "quick.filters.rules.plugin.suspensionStatus.status";
    @VisibleForTesting
    static final String STATUS_ENABLED = "enabled";
    @VisibleForTesting
    static final String STATUS_DISABLED = "disabled";
    private final TextProvider textProvider;

    @Inject
    public SuspensionStatusRuleType(@NotNull TemplateRenderer templateRenderer, @NotNull TextProvider textProvider) {
        super(templateRenderer);
        this.textProvider = textProvider;
    }

    @NotNull
    public String getName() {
        return this.textProvider.getText("quick.filters.rules.plugin.suspensionStatus.name");
    }

    @Nullable
    public String getDescription() {
        return this.textProvider.getText("quick.filters.rules.plugin.suspensionStatus.description");
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return Collections.singleton(CFG_STATUS);
    }

    public void addDefaults(@NotNull Map<String, Object> configuration) {
        configuration.put(CFG_STATUS, STATUS_ENABLED);
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, Object> configuration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!configuration.containsKey(CFG_STATUS)) {
            errorCollection.addError(CFG_STATUS, this.textProvider.getText("quick.filters.rules.plugin.suspensionStatus.status.error.required"));
        } else {
            String status = (String)configuration.get(CFG_STATUS);
            if (!STATUS_ENABLED.equals(status) && !STATUS_DISABLED.equals(status)) {
                errorCollection.addError(CFG_STATUS, this.textProvider.getText("quick.filters.rules.plugin.suspensionStatus.status.error.invalid", Collections.singletonList(status)));
            }
        }
        return errorCollection;
    }

    public boolean matches(@NotNull Map<String, Object> configuration, @NotNull ImmutableTopLevelPlan plan) {
        String status = (String)configuration.get(CFG_STATUS);
        return STATUS_ENABLED.equals(status) != plan.isSuspendedFromBuilding();
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> configuration, @NotNull Map<String, Object> context) {
    }
}

