/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plugin.PluginInjectionHelper;
import com.atlassian.bamboo.plugin.descriptor.RepositoryModuleDescriptorImpl;
import com.atlassian.bamboo.repository.AdvancedConfigurationAwareRepository;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.FilterChangesetAwareRepository;
import com.atlassian.bamboo.repository.IncludeExcludeAwareRepository;
import com.atlassian.bamboo.repository.OnceOffCapableRepository;
import com.atlassian.bamboo.repository.QuietPeriodAwareRepository;
import com.atlassian.bamboo.repository.QuietPeriodHelper;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.repository.RepositoryV2;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.ModuleDescriptor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class AbstractRepository
extends BaseConfigurablePlugin
implements Repository,
IncludeExcludeAwareRepository,
QuietPeriodAwareRepository,
AdvancedConfigurationAwareRepository,
FilterChangesetAwareRepository,
OnceOffCapableRepository {
    private static final Logger log = Logger.getLogger(AbstractRepository.class);
    public static final String REPO_PREFIX = "repository.common.";
    public static final String BUILD_TRIGGER_IP = "repository.change.trigger.triggerIpAddress";
    private transient File workingDirectory;
    private String filterFilePatternOption;
    private String filterFilePatternRegex;
    private String changesetFilterPatternRegex;
    private final QuietPeriodHelper quietPeriodHelper = new QuietPeriodHelper("repository.common.");
    protected RepositoryModuleDescriptorImpl repositoryModuleDescriptor;
    @Deprecated
    protected transient TemplateRenderer templateRenderer;
    @Deprecated
    protected transient TextProvider textProvider;
    @Deprecated
    protected transient BuildLoggerManager buildLoggerManager;
    @Deprecated
    protected transient BuildDirectoryManager buildDirectoryManager;
    @Deprecated
    protected transient CustomVariableContext customVariableContext;
    @Deprecated
    protected transient FeatureManager featureManager;
    @Deprecated
    protected transient AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private transient Optional<TemplateRenderer> templateRendererInternal;
    @Inject
    private transient Optional<TextProvider> textProviderInternal;
    @Inject
    private transient Optional<BuildLoggerManager> buildLoggerManagerInternal;
    @Inject
    private transient Optional<BuildDirectoryManager> buildDirectoryManagerInternal;
    @Inject
    private transient Optional<CustomVariableContext> customVariableContextInternal;
    @Inject
    private transient Optional<FeatureManager> featureManagerInternal;
    @Inject
    private transient Optional<AdministrationConfigurationAccessor> administrationConfigurationAccessorInternal;
    private int maxCommitsToReturn = -1;

    @PostConstruct
    private void postConstruct() {
        this.templateRenderer = (TemplateRenderer)PluginInjectionHelper.firstNotNull(this.templateRenderer, this.templateRendererInternal);
        this.textProvider = (TextProvider)PluginInjectionHelper.firstNotNull(this.textProvider, this.textProviderInternal);
        this.buildLoggerManager = (BuildLoggerManager)PluginInjectionHelper.firstNotNull(this.buildLoggerManager, this.buildLoggerManagerInternal);
        this.buildDirectoryManager = (BuildDirectoryManager)PluginInjectionHelper.firstNotNull(this.buildDirectoryManager, this.buildDirectoryManagerInternal);
        this.customVariableContext = (CustomVariableContext)PluginInjectionHelper.firstNotNull(this.customVariableContext, this.customVariableContextInternal);
        this.featureManager = (FeatureManager)PluginInjectionHelper.firstNotNull(this.featureManager, this.featureManagerInternal);
        this.administrationConfigurationAccessor = (AdministrationConfigurationAccessor)PluginInjectionHelper.firstNotNull(this.administrationConfigurationAccessor, this.administrationConfigurationAccessorInternal);
    }

    @Override
    public void init(@NotNull ModuleDescriptor moduleDescriptor) {
        if (!(moduleDescriptor instanceof RepositoryModuleDescriptorImpl)) {
            throw new IllegalArgumentException("Descriptor not of type " + RepositoryModuleDescriptorImpl.class);
        }
        this.repositoryModuleDescriptor = (RepositoryModuleDescriptorImpl)moduleDescriptor;
    }

    @NotNull
    public String getKey() {
        return this.repositoryModuleDescriptor.getCompleteKey();
    }

    @NotNull
    public String getShortKey() {
        return this.repositoryModuleDescriptor.getKey();
    }

    @NotNull
    public String getLocationIdentifier() {
        return "Repository location information not supplied by plugin";
    }

    public String getDescription() {
        return this.repositoryModuleDescriptor.getDescription();
    }

    @Override
    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
    }

    @Override
    public void customizeBuildRequirements(@NotNull PlanKey planKey, @NotNull BuildConfiguration buildConfiguration, @NotNull RequirementSet requirementSet) {
    }

    @Override
    public void removeBuildRequirements(@NotNull PlanKey planKey, @NotNull BuildConfiguration buildConfiguration, @NotNull RequirementSet requirementSet) {
    }

    protected int getMaxCommitsToReturn() {
        if (this.maxCommitsToReturn == -1) {
            this.maxCommitsToReturn = RepositorySettings.DEFAULT_BUILD_CONTEXT_COMMIT_LIMIT;
        }
        return this.maxCommitsToReturn;
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        log.debug((Object)("Repository " + this.getName() + " has no collectChangesForRevision implementation - falling back to collectChangesSinceLastBuild..."));
        BuildRepositoryChanges buildRepositoryChanges = this.collectChangesSinceLastBuild(planKey.getKey(), targetRevision);
        buildRepositoryChanges.setChanges(buildRepositoryChanges.getChanges().stream().filter(commitContext -> targetRevision.equals(commitContext.guessChangeSetId())).collect(Collectors.toList()));
        return buildRepositoryChanges;
    }

    @Override
    @Deprecated
    @Nullable
    public String getViewHtml(@NotNull Plan plan) {
        return this.templateRenderer.render(this.repositoryModuleDescriptor.getViewTemplate(), (Map)ImmutableMap.of((Object)"repository", (Object)this, (Object)"build", (Object)plan, (Object)"plan", (Object)plan));
    }

    @Override
    @Deprecated
    @Nullable
    public String getEditHtml(@NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        return this.templateRenderer.render(this.repositoryModuleDescriptor.getEditTemplate(), (Map)ImmutableMap.of((Object)"repository", (Object)this, (Object)"build", (Object)plan, (Object)"plan", (Object)plan, (Object)"buildConfiguration", (Object)buildConfiguration));
    }

    @Nullable
    public String getMinimalEditHtml(@NotNull BuildConfiguration buildConfiguration) {
        return this.templateRenderer.render(this.repositoryModuleDescriptor.getMinimalEditTemplate(), (Map)ImmutableMap.of((Object)"repository", (Object)this, (Object)"buildConfiguration", (Object)buildConfiguration));
    }

    @Deprecated
    public String getAdvancedViewHtml(@NotNull Plan plan) {
        return this.templateRenderer.render(this.repositoryModuleDescriptor.getAdvancedViewTemplate(), (Map)ImmutableMap.of((Object)"repository", (Object)this, (Object)"build", (Object)plan, (Object)"plan", (Object)plan));
    }

    @Deprecated
    public String getAdvancedEditHtml(@NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        return this.templateRenderer.render(this.repositoryModuleDescriptor.getAdvancedEditTemplate(), (Map)ImmutableMap.of((Object)"repository", (Object)this, (Object)"build", (Object)plan, (Object)"plan", (Object)plan, (Object)"buildConfiguration", (Object)buildConfiguration));
    }

    @Nullable
    public String getMavenPomCheckoutAccessEditHtml(@NotNull BuildConfiguration buildConfiguration) {
        return this.templateRenderer.render(this.repositoryModuleDescriptor.getMavenPomCheckoutAccessEditTemplate(), (Map)ImmutableMap.of((Object)"repository", (Object)this, (Object)"buildConfiguration", (Object)buildConfiguration));
    }

    @Nullable
    public String getBranchIntegrationEditHtml() {
        return this.templateRenderer.render(this.repositoryModuleDescriptor.getBranchIntegrationEditTemplate(), (Map)ImmutableMap.of((Object)"repository", (Object)this));
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        String changesetFilterRegex;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String filterPatternOption = buildConfiguration.getString("filter.pattern.option");
        if ("includeOnly".equals(filterPatternOption) || "excludeAll".equals(filterPatternOption)) {
            String patternRegex = buildConfiguration.getString("filter.pattern.regex");
            if (StringUtils.isNotEmpty((CharSequence)patternRegex)) {
                try {
                    Pattern.compile(patternRegex);
                }
                catch (PatternSyntaxException e) {
                    errorCollection.addError("filter.pattern.regex", this.textProvider.getText("filter.pattern.regex.invalid.error") + " (" + e.getMessage() + ")");
                }
            } else {
                errorCollection.addError("filter.pattern.regex", this.textProvider.getText("filter.pattern.regex.required.error"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(changesetFilterRegex = buildConfiguration.getString("changeset.filter.pattern.regex")))) {
            try {
                Pattern.compile(changesetFilterRegex);
            }
            catch (PatternSyntaxException e) {
                errorCollection.addError("filter.pattern.regex", this.textProvider.getText("filter.pattern.regex.invalid.error") + " (" + e.getMessage() + ")");
            }
        }
        this.quietPeriodHelper.validate(buildConfiguration, (ErrorCollection)errorCollection);
        return errorCollection;
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.setFilterFilePatternOption(config.getString("filter.pattern.option"));
        this.setFilterFilePatternRegex(config.getString("filter.pattern.regex"));
        this.setChangesetFilterPatternRegex(config.getString("changeset.filter.pattern.regex"));
        this.quietPeriodHelper.populateFromConfig(config);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        XMLConfiguration config = ConfigUtils.newConfiguration();
        config.setProperty("filter.pattern.option", (Object)this.getFilterFilePatternOption());
        config.setProperty("filter.pattern.regex", (Object)this.getFilterFilePatternRegex());
        config.setProperty("changeset.filter.pattern.regex", (Object)this.getChangesetFilterPatternRegex());
        this.quietPeriodHelper.toConfiguration((HierarchicalConfiguration)config);
        return config;
    }

    public boolean isQuietPeriodEnabled() {
        return this.quietPeriodHelper.isQuietPeriodEnabled();
    }

    public int getQuietPeriod() {
        return this.quietPeriodHelper.getQuietPeriod();
    }

    public int getMaxRetries() {
        return this.quietPeriodHelper.getMaxRetries();
    }

    public boolean isAdvancedOptionEnabled(@NotNull BuildConfiguration buildConfiguration) {
        return false;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDirectory = workingDir;
        this.workingDirectory.mkdirs();
    }

    public File getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.buildDirectoryManager.getWorkingDirectoryOfCurrentAgent();
        }
        return this.workingDirectory;
    }

    @NotNull
    public File getSourceCodeDirectory(@NotNull PlanKey planKey) throws RepositoryException {
        return new File(this.getWorkingDirectory(), planKey.getKey());
    }

    @NotNull
    public ErrorCollection checkConnection() {
        ErrorCollection errorCollection = this.validate(new BuildConfiguration(this.toConfiguration()));
        SimpleErrorCollection translatedErrors = new SimpleErrorCollection();
        errorCollection.getErrors().values().stream().flatMap(Collection::stream).forEach(arg_0 -> ((ErrorCollection)translatedErrors).addErrorMessage(arg_0));
        translatedErrors.addErrorMessages(errorCollection.getErrorMessages());
        return translatedErrors;
    }

    protected String substituteString(@Nullable String stringWithValuesToSubstitute) {
        return this.customVariableContext.substituteString(stringWithValuesToSubstitute);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @Override
    @Deprecated
    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public String getFilterFilePatternOption() {
        return this.filterFilePatternOption;
    }

    public void setFilterFilePatternOption(String filterFilePatternOption) {
        this.filterFilePatternOption = filterFilePatternOption;
    }

    public String getFilterFilePatternRegex() {
        return this.filterFilePatternRegex;
    }

    public void setFilterFilePatternRegex(String filterFilePatternRegex) {
        this.filterFilePatternRegex = filterFilePatternRegex;
    }

    public String getChangesetFilterPatternRegex() {
        return this.changesetFilterPatternRegex;
    }

    public void setChangesetFilterPatternRegex(String changesetFilterPatternRegex) {
        this.changesetFilterPatternRegex = changesetFilterPatternRegex;
    }

    public Collection<String> getSystemWideExclusionPatterns() {
        return Lists.newArrayList((Object[])new String[]{"\\[maven-release-plugin\\].*"});
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    protected boolean isWorkspaceEmpty(File sourceCodeDirectory) {
        File[] files;
        if (sourceCodeDirectory != null && sourceCodeDirectory.exists() && (files = sourceCodeDirectory.listFiles()) != null) {
            return files.length == 0 || files.length == 1 && files[0].getName().equals("build-number.txt");
        }
        return true;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setFeatureManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    @Nullable
    public static BranchMergingAwareRepository toMergeCapableRepository(@Nullable RepositoryV2 defaultRepository) {
        BranchMergingAwareRepository branchMergingAwareRepository = (BranchMergingAwareRepository)Narrow.downTo((Object)defaultRepository, BranchMergingAwareRepository.class);
        boolean isMergingSupported = branchMergingAwareRepository != null && branchMergingAwareRepository.isMergingSupported();
        return isMergingSupported ? branchMergingAwareRepository : null;
    }

    @Deprecated
    public static TriggerModuleDescriptor getPollingTriggerModule() {
        String pollingTriggerKey = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll";
        return ((TriggerTypeManager)ComponentAccessor.TRIGGER_TYPE_MANAGER.get()).getTriggerDescriptor("com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll");
    }

    @Deprecated
    public TriggerModuleDescriptor getDefaultTriggerModule() {
        return AbstractRepository.getPollingTriggerModule();
    }
}

