/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.cache.CacheLoadContextSupport;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionCacheIndicesImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.utils.collections.AlwaysInvalidatingCacheDecorator;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionTemplate;

@Internal
class CachedRepositoryDefinitionManagerImpl
implements CachedRepositoryDefinitionManager {
    private static final Logger log = Logger.getLogger(CachedRepositoryDefinitionManagerImpl.class);
    @Inject
    private TransactionTemplate transactionTemplate;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private RepositoryDefinitionDao repositoryDefinitionDao;
    private final RepositoryDefinitionCacheIndicesImpl indices = new RepositoryDefinitionCacheIndicesImpl();
    private volatile boolean isCacheEnabled = false;
    private final CacheLoader<Long, VcsRepositoryData> vcsRepositoryDataLoader = new CacheLoader<Long, VcsRepositoryData>(){

        public VcsRepositoryData load(@NotNull Long repositoryId) throws Exception {
            Callable<VcsRepositoryData> getVcsRepositoryDataInCacheLoadContext = () -> CacheLoadContextSupport.load(CachedRepositoryDefinitionManagerImpl.this.transactionTemplate, CachedRepositoryDefinitionManagerImpl.this.sessionFactory, () -> {
                VcsRepositoryData vcsRepositoryData = CachedRepositoryDefinitionManagerImpl.this.repositoryDefinitionManager.getVcsRepositoryData(repositoryId.longValue());
                if (vcsRepositoryData == null) {
                    throw new RepositoryNotFoundException("Repository " + repositoryId + " not found");
                }
                CachedRepositoryDefinitionManagerImpl.this.indices.index(vcsRepositoryData);
                return vcsRepositoryData;
            });
            return getVcsRepositoryDataInCacheLoadContext.call();
        }
    };
    private final LoadingCache<Long, VcsRepositoryData> vcsRepositoryDataCache = AlwaysInvalidatingCacheDecorator.wrap((LoadingCache)CacheBuilder.newBuilder().softValues().build(this.vcsRepositoryDataLoader));

    CachedRepositoryDefinitionManagerImpl() {
    }

    @Nullable
    public VcsRepositoryData getVcsRepositoryData(long repositoryId) {
        this.assertCacheIsEnabled();
        return this.getVcsRepositoryDataInternal(repositoryId);
    }

    @Nullable
    private VcsRepositoryData getVcsRepositoryDataInternal(long repositoryId) {
        try {
            return (VcsRepositoryData)this.vcsRepositoryDataCache.get((Object)repositoryId);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryNotFoundException) {
                log.debug((Object)"", cause);
                return null;
            }
            throw Throwables.propagate((Throwable)cause);
        }
    }

    public Stream<VcsRepositoryData> findRepositoriesByPluginKey(String pluginKey) {
        this.assertCacheIsEnabled();
        return this.indices.findRepositoriesByPluginKey(pluginKey).stream().map(this::getVcsRepositoryData);
    }

    @Nullable
    public VcsRepositoryData findLinkedRepositoryByName(@NotNull String name) {
        this.assertCacheIsEnabled();
        return this.indices.findLinkedRepositoryByName(name).map(this::getVcsRepositoryData).orElse(null);
    }

    public void invalidate(long repositoryId) {
        Collection<Long> repoIds = this.indices.getRepositoriesAffectedWithChange(repositoryId);
        repoIds.forEach(this.indices::deindex);
        repoIds.forEach(arg_0 -> this.vcsRepositoryDataCache.invalidate(arg_0));
        if (this.isCacheEnabled) {
            repoIds.forEach(this::getVcsRepositoryData);
        }
    }

    public void remove(long repositoryId) {
        this.indices.deindex(repositoryId);
        this.vcsRepositoryDataCache.invalidate((Object)repositoryId);
    }

    public void initialiseCache() {
        this.clearCache();
        Stopwatch watch = Stopwatch.createStarted();
        log.info((Object)"Repository cache initialising...");
        Set allRepositoryIds = this.repositoryDefinitionDao.findAllRepositoryIds();
        Iterator iterator = allRepositoryIds.iterator();
        while (iterator.hasNext()) {
            long repositoryId = (Long)iterator.next();
            this.getVcsRepositoryDataInternal(repositoryId);
        }
        log.info((Object)("Repository cache initialised in " + watch));
        this.isCacheEnabled = true;
    }

    public void disableCache() {
        this.isCacheEnabled = false;
        this.clearCache();
    }

    private void clearCache() {
        this.indices.clear();
        this.vcsRepositoryDataCache.invalidateAll();
    }

    private void assertCacheIsEnabled() {
        if (!this.isCacheEnabled) {
            throw new IllegalStateException("Repository cache is disabled");
        }
    }

    private static class RepositoryNotFoundException
    extends IllegalArgumentException {
        RepositoryNotFoundException(String s) {
            super(s);
        }
    }
}

