/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.plugin.descriptor.RepositoryModuleDescriptorImpl;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.repository.StandaloneRepository;
import com.atlassian.bamboo.repository.plugin.RepositoryModuleDescriptor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultRepositoryManager
implements RepositoryManager {
    private static final Logger log = Logger.getLogger(DefaultRepositoryManager.class);
    private TextProvider textProvider;
    private PluginAccessor pluginAccessor;
    private Ordering repositoryModuleDescriptorOrdering = Ordering.from((o1, o2) -> {
        int x = o1.getConfigurator().getWeight();
        int y = o2.getConfigurator().getWeight();
        return Integer.compare(x, y);
    });

    @NotNull
    public List<Repository> getRepositories() {
        return this.getAvailableRepositoryDescriptors().stream().map(ModuleDescriptor::getModule).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public Repository getNewRepositoryInstance(String key) {
        if (key != null) {
            ModuleDescriptor pluginModuleDescriptor = this.pluginAccessor.getPluginModule(key);
            if (pluginModuleDescriptor == null) {
                log.error((Object)("Could not find repository plugin with key '" + key + "'. This build will be unable to build."));
                return null;
            }
            return (Repository)pluginModuleDescriptor.getModule();
        }
        log.warn((Object)"Key passed was null. A null being returned for repository");
        return null;
    }

    @Nullable
    public MavenPomAccessorCapableRepository getNewRepositoryInstanceFromMavenScmProviderKey(@NotNull String scmProviderKey) {
        return this.pluginAccessor.getEnabledModulesByClass(MavenPomAccessorCapableRepository.class).stream().filter(repository -> scmProviderKey.equals(repository.getMavenPomAccessor().getMavenScmProviderKey())).findFirst().orElse(null);
    }

    @NotNull
    public List<NameValuePair> getFilterOptions() {
        ArrayList<NameValuePair> options = new ArrayList<NameValuePair>();
        options.add(new NameValuePair("none", "None", "none"));
        options.add(new NameValuePair("includeOnly", this.textProvider.getText("filter.pattern.option.includeOnly"), "regex"));
        options.add(new NameValuePair("excludeAll", this.textProvider.getText("filter.pattern.option.excludeAll"), "regex"));
        return options;
    }

    @NotNull
    public List<RepositoryModuleDescriptor> getAvailableRepositoryDescriptors() {
        return this.repositoryModuleDescriptorOrdering.immutableSortedCopy((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(RepositoryModuleDescriptorImpl.class));
    }

    @NotNull
    public List<RepositoryModuleDescriptor> getAvailableStandaloneRepositoryDescriptors() {
        return this.repositoryModuleDescriptorOrdering.immutableSortedCopy(Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(RepositoryModuleDescriptorImpl.class), input -> StandaloneRepository.class.isAssignableFrom(input.getModuleClass())));
    }

    @Nullable
    public RepositoryModuleDescriptor getRepositoryModuleDescriptor(String pluginKey) {
        return (RepositoryModuleDescriptor)Narrow.to((Object)this.pluginAccessor.getEnabledPluginModule(pluginKey), RepositoryModuleDescriptor.class);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

