/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryPermissionsService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.PermissionsServiceUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooAclHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;

public class DefaultRepositoryPermissionsService
implements RepositoryPermissionsService {
    private static final Collection<BambooPermission> SUPPORTED_PERMISSIONS = ImmutableSet.builder().add((Object)BambooPermission.READ).add((Object)BambooPermission.ADMINISTRATION).build();
    private static final Multimap<BambooPermission, BambooPermission> PERMISSION_DEPENDENCIES = ImmutableMultimap.builder().put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.READ).build();
    private final Function<Long, ManagedLock> lockFactory = ManagedLocks.weakManagedLockFactory();
    private final TransactionAndHibernateTemplate hibernateTemplate;
    private final HibernateMutableAclService aclService;
    private final BambooAclHelper aclHelper;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final BambooPermissionManager bambooPermissionManager;
    private final BambooUserManager bambooUserManager;

    @Autowired
    public DefaultRepositoryPermissionsService(TransactionAndHibernateTemplate hibernateTemplate, HibernateMutableAclService aclService, BambooAclHelper aclHelper, RepositoryDefinitionManager repositoryDefinitionManager, BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager) {
        this.hibernateTemplate = hibernateTemplate;
        this.aclService = aclService;
        this.aclHelper = aclHelper;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.bambooUserManager = bambooUserManager;
    }

    @NotNull
    private MutableAcl getAclForRepository(@NotNull RepositoryDataEntity deploymentProject) {
        return this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl(deploymentProject));
    }

    @NotNull
    public Iterable<String> listUsersWithPermissionsForRepository(long repositoryId) {
        RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
        this.hasPermissionForRepository(repository);
        MutableAcl repositoryAcl = this.getAclForRepository(repository);
        return this.aclHelper.listUsersWithPermissions((Acl)repositoryAcl, this.supportedPermissions());
    }

    @NotNull
    public List<BambooPermission> getUserPermissionsForRepository(long repositoryId, @NotNull String username) {
        RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
        this.hasPermissionForRepository(repository);
        User user = PermissionsServiceUtils.validateUser(username, this.bambooUserManager);
        MutableAcl repositoryAcl = this.getAclForRepository(repository);
        return this.aclHelper.getUserPermissions((Acl)repositoryAcl, user.getName(), this.supportedPermissions());
    }

    public boolean addUserPermissionsToRepository(long repositoryId, @NotNull String username, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(repositoryId, () -> {
            RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
            this.hasPermissionForRepository(repository);
            User user = PermissionsServiceUtils.validateUser(username, this.bambooUserManager);
            this.validatePermissionsForRepository(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getUserPermissionsForRepository(repositoryId, user.getName()), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToRepository(repositoryId, permissionKeysToAdd);
        });
    }

    public boolean removeUserPermissionsFromRepository(long repositoryId, @NotNull String username, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(repositoryId, () -> {
            RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
            this.hasPermissionForRepository(repository);
            User user = PermissionsServiceUtils.validateUser(username, this.bambooUserManager);
            this.validateDependenciesAfterRevoking(this.getUserPermissionsForRepository(repositoryId, user.getName()), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromRepository(repositoryId, permissionKeysToRemove);
        });
    }

    @NotNull
    public Iterable<String> listGroupsWithPermissionsForRepository(long repositoryId) {
        RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
        this.hasPermissionForRepository(repository);
        MutableAcl acl = this.getAclForRepository(repository);
        return this.aclHelper.listGroupsWithPermissions((Acl)acl, this.supportedPermissions());
    }

    @NotNull
    public List<BambooPermission> getGroupPermissionsForRepository(long repositoryId, @NotNull String groupName) {
        RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
        this.hasPermissionForRepository(repository);
        Group group = PermissionsServiceUtils.validateGroup(groupName, this.bambooUserManager);
        MutableAcl acl = this.getAclForRepository(repository);
        return this.aclHelper.getGroupPermissions((Acl)acl, group.getName(), this.supportedPermissions());
    }

    public boolean addGroupPermissionsToRepository(long repositoryId, @NotNull String groupName, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(repositoryId, () -> {
            RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
            this.hasPermissionForRepository(repository);
            PermissionsServiceUtils.validateGroup(groupName, this.bambooUserManager);
            this.validatePermissionsForRepository(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getGroupPermissionsForRepository(repositoryId, groupName), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(groupName, permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToRepository(repositoryId, permissionKeysToAdd);
        });
    }

    public boolean removeGroupPermissionsFromRepository(long repositoryId, @NotNull String groupName, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(repositoryId, () -> {
            RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
            this.hasPermissionForRepository(repository);
            Group group = PermissionsServiceUtils.validateGroup(groupName, this.bambooUserManager);
            this.validateDependenciesAfterRevoking(this.getGroupPermissionsForRepository(repositoryId, group.getName()), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(group.getName(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromRepository(repositoryId, permissionKeysToRemove);
        });
    }

    @NotNull
    public List<BambooPermission> getLoggedInPermissionsForRepository(long repositoryId) {
        RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
        this.hasPermissionForRepository(repository);
        MutableAcl acl = this.getAclForRepository(repository);
        return this.aclHelper.getLoggedInPermissions((Acl)acl, this.supportedPermissions());
    }

    public boolean addLoggedInPermissionsToRepository(long repositoryId, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(repositoryId, () -> {
            RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
            this.hasPermissionForRepository(repository);
            this.validatePermissionsForRepository(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getLoggedInPermissionsForRepository(repositoryId), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToRepository(repositoryId, permissionKeysToAdd);
        });
    }

    public boolean removeLoggedInPermissionsFromRepository(long repositoryId, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(repositoryId, () -> {
            RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
            this.hasPermissionForRepository(repository);
            this.validateDependenciesAfterRevoking(this.getLoggedInPermissionsForRepository(repositoryId), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromRepository(repositoryId, permissionKeysToRemove);
        });
    }

    private void hasPermissionForRepository(RepositoryDataEntity repository) {
        PermissionsServiceUtils.assertCanManagePermissionsForRepository(repository, this.bambooPermissionManager);
    }

    @NotNull
    public Collection<BambooPermission> supportedPermissions() {
        return SUPPORTED_PERMISSIONS;
    }

    @NotNull
    public Collection<BambooPermission> permissionDependencies(@NotNull BambooPermission permission) {
        return PermissionsServiceUtils.extractDependencies(PERMISSION_DEPENDENCIES, this.supportedPermissions(), permission);
    }

    private RepositoryDataEntity validateRepositoryId(long repositoryId) {
        RepositoryDataEntity repository = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
        Preconditions.checkArgument((repository != null ? 1 : 0) != 0, (String)"Repository: %s does not exist", (Object[])new Object[]{repositoryId});
        return repository;
    }

    private void validatePermissionsForRepository(List<BambooPermission> permissions) {
        PermissionsServiceUtils.validatePermissions(permissions, this.supportedPermissions(), "repository");
    }

    private void validateDependenciesAfterGranting(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToAdd) {
        Sets.SetView effectivePermissions = Sets.union(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToAdd));
        PermissionsServiceUtils.validateDependenciesAfterGranting((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private void validateDependenciesAfterRevoking(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToRemove) {
        Sets.SetView effectivePermissions = Sets.difference(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToRemove));
        PermissionsServiceUtils.validateDependenciesAfterRevoking((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private boolean addPermissionKeysToRepository(long repositoryId, List<String> permissionKeysToAdd) {
        RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
        MutableAcl acl = this.getAclForRepository(repository);
        return this.aclHelper.addPermissionKeys(acl, permissionKeysToAdd);
    }

    private boolean removePermissionKeysFromRepository(long repositoryId, List<String> permissionKeysToRemove) {
        RepositoryDataEntity repository = this.validateRepositoryId(repositoryId);
        MutableAcl acl = this.getAclForRepository(repository);
        return this.aclHelper.removePermissionKeys(acl, permissionKeysToRemove);
    }

    private <T> T withExclusiveLock(long repositoryId, Supplier<T> supplier) {
        return (T)this.lockFactory.apply(repositoryId).withLock(() -> this.hibernateTemplate.execute(arg_0 -> DefaultRepositoryPermissionsService.lambda$null$12((Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ Object lambda$null$12(Supplier supplier, TransactionStatus transactionStatus) {
        return supplier.get();
    }
}

