/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.repository.EncryptedRepositoryDefinitionAccessor;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncryptedRepositoryDefinitionAccessorImpl
implements EncryptedRepositoryDefinitionAccessor {
    private final RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    private final RepositoryDefinitionDao repositoryDefinitionDao;

    public EncryptedRepositoryDefinitionAccessorImpl(RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter, RepositoryDefinitionDao repositoryDefinitionDao) {
        this.repositoryDefinitionDao = repositoryDefinitionDao;
        this.rawRepositoryConfigurationXmlConverter = rawRepositoryConfigurationXmlConverter;
    }

    @NotNull
    public List<VcsRepositoryData> getLinkedRepositories() {
        return this.repositoryDefinitionDao.getGlobalRepositoryDefinitions().stream().map(this::entityToVcsData).collect(Collectors.toList());
    }

    @Nullable
    public VcsRepositoryData getVcsRepositoryDataByOid(BambooEntityOid oid) {
        return this.entityToVcsData((RepositoryDataEntity)this.repositoryDefinitionDao.findByOid(oid, RepositoryDataEntity.class));
    }

    @Nullable
    private VcsRepositoryData entityToVcsData(@Nullable RepositoryDataEntity input) {
        return input != null ? new VcsRepositoryDataImpl(this.entityToUnmergedData(input).getCompleteData()) : null;
    }

    private PartialVcsRepositoryData entityToUnmergedData(@NotNull RepositoryDataEntity entity) {
        PartialVcsRepositoryData parent = entity.getParent() != null ? this.entityToUnmergedData(entity.getParent()) : null;
        return new PartialVcsRepositoryDataImpl(entity, this.rawRepositoryConfigurationXmlConverter.fromEntity(entity), parent != null ? parent.getCompleteData() : null);
    }
}

