/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.event.PlanSuspensionRequestedEvent;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.event.api.EventPublisher;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class InvalidRepositoryException
extends RepositoryException {
    private static final Logger log = Logger.getLogger(InvalidRepositoryException.class);

    public InvalidRepositoryException(String message) {
        super(message);
    }

    public InvalidRepositoryException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidRepositoryException(String message, Throwable cause, String stdout, String stderr) {
        super(message, cause, stdout, stderr);
    }

    public InvalidRepositoryException(String message, String stdout, String stderr) {
        super(message, stdout, stderr);
    }

    public InvalidRepositoryException(String message, Throwable cause, String stdout, String stderr, long repositoryId) {
        super(message, cause, stdout, stderr, repositoryId);
    }

    public static boolean handleInvalidRepositoryIfAppropriate(@Nullable PlanKey planKey, Throwable e, ErrorCollection errorCollection, EventPublisher eventPublisher, @Nullable ErrorHandler errorHandler) {
        InvalidRepositoryException invalidRepositoryException = e instanceof InvalidRepositoryException ? (InvalidRepositoryException)((Object)e) : (e.getCause() instanceof InvalidRepositoryException ? (InvalidRepositoryException)((Object)e.getCause()) : null);
        if (planKey != null && invalidRepositoryException != null) {
            String message = "Plan '" + planKey + "' detected that the repository is invalid. The plan will be disabled.";
            errorCollection.addErrorMessage(message);
            if (errorHandler != null) {
                errorHandler.recordError((Key)planKey, message);
            } else {
                log.info((Object)message);
            }
            eventPublisher.publish((Object)new PlanSuspensionRequestedEvent(planKey, planKey, message + " Error was: " + invalidRepositoryException.getMessage()));
            return true;
        }
        return false;
    }
}

