/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryConfigurationReference;
import com.atlassian.bamboo.repository.RepositoryConfigurationReferenceConverter;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryReference;
import com.atlassian.bamboo.repository.WebRepositoryViewerReference;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class LegacyRepositoryDataImpl
implements RepositoryData {
    private static final Logger log = Logger.getLogger(LegacyRepositoryDataImpl.class);
    private final BambooEntityOid oid;
    private final long id;
    private final String pluginKey;
    private final String name;
    private final String description;
    private final boolean global;
    private final boolean markedForDeletion;
    private transient RepositoryReference repositoryRef = new RepositoryReference(this);
    private transient WebRepositoryViewerReference webRepositoryViewerRef = new WebRepositoryViewerReference(this);
    @XStreamAlias(value="xmlData")
    @XStreamConverter(value=RepositoryConfigurationReferenceConverter.class)
    private RepositoryConfigurationReference configurationRef;

    public LegacyRepositoryDataImpl(RepositoryDataEntity repositoryData) {
        this.id = repositoryData.getId();
        this.oid = repositoryData.getOid();
        this.pluginKey = BambooInterners.moduleKey((String)repositoryData.getPluginKey());
        this.name = BambooInterners.intern((String)repositoryData.getName());
        this.description = BambooInterners.intern((String)repositoryData.getDescription());
        this.configurationRef = new RepositoryConfigurationReference(repositoryData.getXmlData());
        this.markedForDeletion = repositoryData.isMarkedForDeletion();
        this.global = repositoryData.isGlobal();
    }

    public LegacyRepositoryDataImpl(VcsRepositoryData repositoryData, RepositoryConfigurationReference configurationRef) {
        this.id = repositoryData.getId();
        this.oid = repositoryData.getOid();
        this.pluginKey = BambooInterners.moduleKey((String)repositoryData.getPluginKey());
        this.name = BambooInterners.intern((String)repositoryData.getName());
        this.description = BambooInterners.intern((String)repositoryData.getDescription());
        this.configurationRef = configurationRef;
        this.markedForDeletion = repositoryData.isMarkedForDeletion();
        this.global = repositoryData.isLinked();
    }

    public LegacyRepositoryDataImpl(VcsRepositoryData repositoryData, String legacyPluginKey, RepositoryConfigurationReference configurationRef) {
        this.id = repositoryData.getId();
        this.oid = repositoryData.getOid();
        this.pluginKey = BambooInterners.moduleKey((String)legacyPluginKey);
        this.name = BambooInterners.intern((String)repositoryData.getName());
        this.description = BambooInterners.intern((String)repositoryData.getDescription());
        this.configurationRef = configurationRef;
        this.markedForDeletion = repositoryData.isMarkedForDeletion();
        this.global = repositoryData.isLinked();
    }

    public LegacyRepositoryDataImpl(long id, String pluginKey, String name, String description, String xmlData, boolean markedForDeletion, boolean global) {
        this.id = id;
        this.oid = null;
        this.pluginKey = BambooInterners.moduleKey((String)pluginKey);
        this.name = BambooInterners.intern((String)name);
        this.description = BambooInterners.intern((String)description);
        this.markedForDeletion = markedForDeletion;
        this.configurationRef = new RepositoryConfigurationReference(xmlData);
        this.global = global;
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @NotNull
    public String getWebRepositoryPluginKey() {
        return this.getConfiguration().getString("selectedWebRepositoryViewer", "bamboo.webrepositoryviewer.provided:noRepositoryViewer");
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    @NotNull
    public Repository getRepository() {
        return (Repository)this.repositoryRef.get();
    }

    public Repository getNewRepositoryInstance() {
        return (Repository)new RepositoryReference(this).get();
    }

    @NotNull
    public WebRepositoryViewer getWebRepositoryViewer() {
        return (WebRepositoryViewer)this.webRepositoryViewerRef.get();
    }

    @NotNull
    public HierarchicalConfiguration getConfiguration() {
        return this.configurationRef.get();
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof LegacyRepositoryDataImpl)) {
            return false;
        }
        LegacyRepositoryDataImpl that = (LegacyRepositoryDataImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    protected Object readResolve() {
        this.repositoryRef = new RepositoryReference(this);
        this.webRepositoryViewerRef = new WebRepositoryViewerReference(this);
        return this;
    }

    public String toString() {
        return "RepositoryDataImpl{id=" + this.id + ", pluginKey='" + this.pluginKey + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", global=" + this.global + ", markedForDeletion=" + this.markedForDeletion + ", repositoryRef=" + (Object)((Object)this.repositoryRef) + ", webRepositoryViewerRef=" + (Object)((Object)this.webRepositoryViewerRef) + ", configurationRef=" + this.configurationRef + '}';
    }
}

