/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.build.BuildConfigurationValidationUtils;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;

public class QuietPeriodHelper
implements Serializable {
    private static final Logger log = Logger.getLogger(QuietPeriodHelper.class);
    public static final int DEFAULT_QUIET_PERIOD = 10;
    public static final int DEFAULT_MAX_RETRIES = 5;
    private final String QUIET_PERIOD_ENABLED;
    private final String QUIET_PERIOD;
    private final String MAX_RETRIES;
    private boolean quietPeriodEnabled = false;
    private int quietPeriod = 10;
    private int maxRetries = 5;

    public QuietPeriodHelper(String repoPrefix) {
        String quietPeriodPrefix = repoPrefix + "quietPeriod.";
        this.QUIET_PERIOD_ENABLED = BambooInterners.intern((String)(quietPeriodPrefix + "enabled"));
        this.QUIET_PERIOD = BambooInterners.intern((String)(quietPeriodPrefix + "period"));
        this.MAX_RETRIES = BambooInterners.intern((String)(quietPeriodPrefix + "maxRetries"));
    }

    public void validate(BuildConfiguration buildConfiguration, ErrorCollection errorCollection) {
        if (buildConfiguration.getBoolean(this.QUIET_PERIOD_ENABLED, false)) {
            BuildConfigurationValidationUtils.validatePostiveInteger(this.QUIET_PERIOD, "Please specify the quiet period (in seconds)", "Please specify the quiet period as an integer (in seconds)", buildConfiguration, errorCollection);
            BuildConfigurationValidationUtils.validatePostiveInteger(this.MAX_RETRIES, "Please specify the maximum number of retries", "Please specify the maximum number of retries as an integer", buildConfiguration, errorCollection);
        }
    }

    public void populateFromConfig(HierarchicalConfiguration config) {
        this.quietPeriodEnabled = config.getBoolean(this.QUIET_PERIOD_ENABLED, false);
        if (this.quietPeriodEnabled) {
            this.quietPeriod = config.getInt(this.QUIET_PERIOD);
            this.maxRetries = config.getInt(this.MAX_RETRIES);
        }
    }

    public void toConfiguration(HierarchicalConfiguration configuration) {
        configuration.setProperty(this.QUIET_PERIOD_ENABLED, (Object)this.quietPeriodEnabled);
        configuration.setProperty(this.QUIET_PERIOD, (Object)this.quietPeriod);
        configuration.setProperty(this.MAX_RETRIES, (Object)this.maxRetries);
    }

    public boolean isEnabled(BuildConfiguration buildConfiguration) {
        return buildConfiguration.getBoolean(this.QUIET_PERIOD_ENABLED, false);
    }

    public boolean isQuietPeriodEnabled() {
        return this.quietPeriodEnabled;
    }

    public int getQuietPeriod() {
        return this.quietPeriod;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }
}

