/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionRepositoryAccessor {
    private static Method getMethod(Class<? extends Repository> repositoryClass, String methodName) {
        try {
            return repositoryClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
    }

    private static Object invoke(Repository stashRepository, Method applicationLinkMethod) {
        try {
            return applicationLinkMethod.invoke((Object)stashRepository, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
    }

    public static class StashRepositoryAccessor {
        private StashRepositoryAccessor() {
        }

        public static Method getStashProjectKeyMethod(Class<? extends Repository> stashRepositoryClass) {
            return ReflectionRepositoryAccessor.getMethod(stashRepositoryClass, "getStashProjectKey");
        }

        public static Method getStashRepositorySlugMethod(Class<? extends Repository> stashRepositoryClass) {
            return ReflectionRepositoryAccessor.getMethod(stashRepositoryClass, "getStashRepositorySlug");
        }

        public static Method getApplicationLinkMethod(Class<? extends Repository> stashRepositoryClass) {
            return ReflectionRepositoryAccessor.getMethod(stashRepositoryClass, "getApplicationLink");
        }

        @Nullable
        public static ApplicationLink getApplicationLink(Repository stashRepository) {
            return (ApplicationLink)ReflectionRepositoryAccessor.invoke(stashRepository, StashRepositoryAccessor.getApplicationLinkMethod(stashRepository.getClass()));
        }

        @NotNull
        public static String getApplicationLinkId(VcsLocationDefinition vcsLocation) {
            return (String)vcsLocation.getConfiguration().get("repository.stash.server");
        }

        public static boolean isStashRepository(Repository repository) {
            return repository.getClass().getCanonicalName().equals("com.atlassian.bamboo.plugins.stash.StashRepositoryImpl");
        }

        public static boolean isStashRepository(VcsRepositoryData repositoryDefinition) {
            return repositoryDefinition.getPluginKey().equals("com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver");
        }

        @NotNull
        public static String getStashRepositorySlug(VcsLocationDefinition vcsLocation) {
            return (String)vcsLocation.getConfiguration().get("repository.stash.repositorySlug");
        }

        public static String getStashRepositorySlug(Repository repository) {
            try {
                Method stashRepositorySlugMethod = StashRepositoryAccessor.getStashRepositorySlugMethod(repository.getClass());
                stashRepositorySlugMethod.setAccessible(true);
                return (String)stashRepositorySlugMethod.invoke((Object)repository, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        }

        public static String getStashProjectKey(Repository repository) {
            try {
                Method stashProjectKeyMethod = StashRepositoryAccessor.getStashProjectKeyMethod(repository.getClass());
                stashProjectKeyMethod.setAccessible(true);
                return (String)stashProjectKeyMethod.invoke((Object)repository, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        }

        @NotNull
        public static String getStashProjectKey(VcsLocationDefinition vcsLocation) {
            return (String)vcsLocation.getConfiguration().get("repository.stash.projectKey");
        }
    }
}

