/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.repository.RemoveOrphanedSpecsStateJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class RemoveOrphanedSpecsStateScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(RemoveOrphanedSpecsStateScheduler.class);
    private static final String REMOVE_ORPHANED_SPECS_STATE_JOB = "removeOrphanedSpecsStateJob";
    private static final String REMOVE_ORPHANED_SPECS_STATE_GROUP = "removeOrphanedSpecsStateGroup";
    private static final JobKey JOB_KEY = new JobKey("removeOrphanedSpecsStateJob", "removeOrphanedSpecsStateGroup");
    private static final String REMOVE_ORPHANED_SPECS_STATE_TRIGGER = "removeOrphanedSpecsStateTrigger";
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("removeOrphanedSpecsStateTrigger", "removeOrphanedSpecsStateGroup");
    private static final String CRON_EXPRESSION = "0 0 2 9,24 * ?";
    private final Scheduler quartzScheduler;

    public RemoveOrphanedSpecsStateScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        try {
            JobDetail jobDetail = JobBuilder.newJob(RemoveOrphanedSpecsStateJob.class).withIdentity(JOB_KEY).build();
            CronExpression cronExpression = new CronExpression(CRON_EXPRESSION);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).forJob(JOB_KEY).build();
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            log.info((Object)("Used '0 0 2 9,24 * ?' to schedule " + RemoveOrphanedSpecsStateJob.class.getSimpleName() + ". Next trigger time " + cronTrigger.getNextFireTime()));
        }
        catch (Exception e) {
            log.error((Object)"Unable to schedule removeOrphanedSpecsStateJob", (Throwable)e);
        }
    }
}

