/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.executor.RetryingTaskExecutor;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.repository.BranchDetectionCapableRepository;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.RepositoryCachingFacade;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.util.CallableResultCache;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.atlassian.bamboo.vcs.runtime.VcsPullRequestDetector;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryCachingFacadeImpl
implements RepositoryCachingFacade {
    private static final Logger log = Logger.getLogger(RepositoryCachingFacade.class);
    private final CallableResultCache<List<VcsBranch>> OPEN_BRANCH_CACHE = CallableResultCache.buildAlwaysInvalidating((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES), CacheAwareness.BRANCH_DETECTION);
    private final CallableResultCache<List<VcsPullRequest>> OPEN_PULL_REQUEST_CACHE = CallableResultCache.buildAlwaysInvalidating((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterWrite(Math.max(SystemProperty.PULL_REQUEST_CACHE_TTL.getTypedValue(), 1L), TimeUnit.SECONDS), CacheAwareness.BRANCH_DETECTION);

    private RepositoryCachingFacadeImpl() {
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull VcsBranchDetector branchDetector, @NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        List<VcsBranch> branchesInVcs;
        final ContextualVcsId cacheId = branchDetector.getVcsIdForExecutor(repositoryData);
        Callable<List<VcsBranch>> getOpenBranches = new Callable<List<VcsBranch>>(){

            @Override
            public List<VcsBranch> call() {
                try {
                    return this.getOpenBranchesCaller((ContextualVcsId<VcsBranchDetector>)cacheId);
                }
                catch (RepositoryException e) {
                    return RetryingTaskExecutor.retry("Detecting branches " + cacheId.getSourceData().getName(), ChangeDetectionManager.MAX_OPERATION_RETRIES, RetryingTaskExecutor.randomInitialDelay().plusSeconds(5L), () -> this.getOpenBranchesCaller((ContextualVcsId<VcsBranchDetector>)cacheId));
                }
            }

            @NotNull
            private List<VcsBranch> getOpenBranchesCaller(ContextualVcsId<VcsBranchDetector> key) throws RepositoryException {
                return ((VcsBranchDetector)key.getExecutor()).getOpenBranches(key.getSourceData());
            }
        };
        if (cacheId != null) {
            try {
                branchesInVcs = this.OPEN_BRANCH_CACHE.call(getOpenBranches, cacheId);
            }
            catch (Exception e) {
                throw BambooObjectUtils.rethrowAnyCauseThatIsInstanceOf((Throwable)e.getCause(), RepositoryException.class);
            }
        } else {
            branchesInVcs = branchDetector.getOpenBranches(repositoryData);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.OPEN_BRANCH_CACHE.stats());
        }
        return branchesInVcs;
    }

    @NotNull
    public List<VcsPullRequest> getOpenPullRequests(@NotNull VcsPullRequestDetector pullRequestDetector, @NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        List<VcsPullRequest> pullRequestsInVcs;
        final ContextualVcsId cacheId = pullRequestDetector.getVcsIdForExecutor(repositoryData);
        Callable<List<VcsPullRequest>> getOpenPullRequests = new Callable<List<VcsPullRequest>>(){

            @Override
            public List<VcsPullRequest> call() throws Exception {
                return this.getOpenPullRequests((ContextualVcsId<VcsPullRequestDetector>)cacheId);
            }

            @NotNull
            private List<VcsPullRequest> getOpenPullRequests(ContextualVcsId<VcsPullRequestDetector> key) throws RepositoryException {
                return ((VcsPullRequestDetector)key.getExecutor()).getOpenPullRequests(key.getSourceData());
            }
        };
        if (cacheId != null) {
            try {
                pullRequestsInVcs = this.OPEN_PULL_REQUEST_CACHE.call(getOpenPullRequests, cacheId);
            }
            catch (Exception e) {
                throw BambooObjectUtils.rethrowAnyCauseThatIsInstanceOf((Throwable)e.getCause(), RepositoryException.class);
            }
        } else {
            pullRequestsInVcs = pullRequestDetector.getOpenPullRequests(repositoryData);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.OPEN_PULL_REQUEST_CACHE.stats());
        }
        return pullRequestsInVcs;
    }

    public void invalidate(VcsBranchDetector branchDetector, VcsRepositoryData repositoryData) {
    }

    public void invalidate(VcsPullRequestDetector pullRequestDetector, VcsRepositoryData repositoryData) {
    }

    @Nullable
    static CacheId getCacheId(BranchDetectionCapableRepository repository, CachingAwareRepository.CachableOperation cachableOperation, @Nullable String context) {
        CachingAwareRepository cachingAwareRepository = (CachingAwareRepository)Narrow.reinterpret((Object)repository, CachingAwareRepository.class);
        if (cachingAwareRepository != null && cachingAwareRepository.isCachingSupportedFor(cachableOperation)) {
            CacheId cacheId = cachingAwareRepository.getCacheId(CachingAwareRepository.CachableOperation.BRANCH_DETECTION);
            cacheId = CacheId.forContext((CacheId)cacheId, (String)context);
            return cacheId;
        }
        return null;
    }
}

