/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.commonsconfig.BambooHierarchicalConfiguration;
import com.atlassian.bamboo.utils.CommonsConfigUtils;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.concurrent.TransientLazyReference;
import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.StrictConfigurationComparator;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

@Internal
public class RepositoryConfigurationReference
implements Supplier<HierarchicalConfiguration> {
    private static final Logger log = Logger.getLogger(RepositoryConfigurationReference.class);
    private volatile String repositoryDataXml;
    private final transient TransientLazyReference<HierarchicalConfiguration> configuration;

    public RepositoryConfigurationReference(String xmlData) {
        this.repositoryDataXml = xmlData;
        this.configuration = new ConfigurationTransientReference();
    }

    public RepositoryConfigurationReference(final HierarchicalConfiguration preExistingConfig) {
        this.repositoryDataXml = null;
        this.configuration = new TransientLazyReference<HierarchicalConfiguration>(){

            protected HierarchicalConfiguration create() {
                return preExistingConfig;
            }
        };
    }

    @Override
    public HierarchicalConfiguration get() {
        return (HierarchicalConfiguration)this.configuration.get();
    }

    public String getXmlString() {
        String repositoryDataXml = this.repositoryDataXml;
        if (repositoryDataXml != null) {
            return repositoryDataXml;
        }
        return ConfigUtils.asXmlString((HierarchicalConfiguration)this.get());
    }

    public static class RepoHierarchicalConfiguration
    extends BambooHierarchicalConfiguration {
        public RepoHierarchicalConfiguration() {
            this.setDelimiterParsingDisabled(true);
        }

        public boolean getBoolean(String key) {
            try {
                return super.getBoolean(key);
            }
            catch (NoSuchElementException e) {
                log.debug((Object)("Key '" + key + "' returned no value. false being returned"));
                return false;
            }
        }

        public int getInt(String key) {
            try {
                return super.getInt(key);
            }
            catch (NoSuchElementException e) {
                log.info((Object)("Key '" + key + "' returned no value. -1 being returned"));
                return -1;
            }
        }
    }

    private class ConfigurationTransientReference
    extends TransientLazyReference<HierarchicalConfiguration> {
        private ConfigurationTransientReference() {
        }

        protected HierarchicalConfiguration create() {
            String localRepositoryDataXml = RepositoryConfigurationReference.this.repositoryDataXml;
            RepositoryConfigurationReference.this.repositoryDataXml = null;
            XMLConfiguration xmlConfigFromXmlString = ConfigUtils.getXmlConfigFromXmlString((String)localRepositoryDataXml);
            RepoHierarchicalConfiguration repoHierarchicalConfiguration = new RepoHierarchicalConfiguration();
            CommonsConfigUtils.copyContent((XMLConfiguration)xmlConfigFromXmlString, (HierarchicalConfiguration)repoHierarchicalConfiguration);
            boolean isTheSame = new StrictConfigurationComparator().compare((Configuration)xmlConfigFromXmlString, (Configuration)repoHierarchicalConfiguration);
            Preconditions.checkArgument((boolean)isTheSame, (Object)("Configuration roundtrip mismatch for " + localRepositoryDataXml));
            return repoHierarchicalConfiguration;
        }
    }
}

