/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.BranchAwareRepository;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryConfigurationService;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryConfigurationServiceImpl
implements RepositoryConfigurationService {
    private static final Logger log = Logger.getLogger(RepositoryConfigurationServiceImpl.class);
    private static final String REPOSITORY_HAS_BEEN_REMOVED = "Repository has been removed.";
    private static final String REPOSITORY_HAS_BEEN_CREATED = "Repository has been created.";
    private static final String REPOSITORY_TYPE_HAS_BEEN_CHANGED = "Repository type has been changed.";
    private static final String REPOSITORY_HAS_BEEN_MOVED = "Repository has been moved.";
    private static final String GLOBAL_REPOSITORY_LOCK_NAME = "__GLOBAL_REPOSITORY__LOCK__";
    private static final String GLOBAL_REPOSITORY_HAS_BEEN_CREATED = "Global repository %s has been created.";
    private static final String GLOBAL_REPOSITORY_HAS_BEEN_DELETED = "Global repository %s has been deleted.";
    private static final String GLOBAL_REPOSITORY_TYPE_HAS_BEEN_CHANGED = "Global repository %s type has been changed.";
    private static final String GLOBAL_REPOSITORY_CONFIGURATION_HAS_BEEN_CHANGED = "Global repository configuration has been changed.";
    private static final String GLOBAL_REPOSITORY_HAS_BEEN_ATTACHED = "Global repository %s has been attached.";
    private final PlanManager planManager;
    private final RepositoryManager repositoryManager;
    private final WebRepositoryViewerManager webRepositoryViewerManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;

    public RepositoryConfigurationServiceImpl(@NotNull PlanManager planManager, @NotNull RepositoryManager repositoryManager, @NotNull WebRepositoryViewerManager webRepositoryViewerManager, @NotNull RepositoryDefinitionManager repositoryDefinitionManager) {
        this.planManager = planManager;
        this.repositoryManager = repositoryManager;
        this.webRepositoryViewerManager = webRepositoryViewerManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public static Map<String, String> extractChangeDetectionOptionFromConfiguration(@NotNull HierarchicalConfiguration configuration) {
        HashMap<String, String> changeDetectionConfig = new HashMap<String, String>();
        changeDetectionConfig.put("commit.isolation.option", Boolean.toString(configuration.getBoolean("commit.isolation.option", false)));
        boolean quietPeriodEnabled = configuration.getBoolean("repository.common.quietPeriod.enabled", false);
        changeDetectionConfig.put("repository.common.quietPeriod.enabled", Boolean.toString(quietPeriodEnabled));
        if (quietPeriodEnabled) {
            changeDetectionConfig.put("repository.common.quietPeriod.period", configuration.getString("repository.common.quietPeriod.period"));
            changeDetectionConfig.put("repository.common.quietPeriod.maxRetries", configuration.getString("repository.common.quietPeriod.maxRetries"));
        }
        changeDetectionConfig.put("filter.pattern.option", configuration.getString("filter.pattern.option", "none"));
        changeDetectionConfig.put("filter.pattern.regex", configuration.getString("filter.pattern.regex", ""));
        changeDetectionConfig.put("changeset.filter.pattern.regex", configuration.getString("changeset.filter.pattern.regex", ""));
        return changeDetectionConfig;
    }

    private PartialVcsRepositoryData repositoryDataFromHierarchicalConfiguration(@NotNull String repositoryName, @NotNull String inputPluginKey, @Nullable String webRepositoryKey, @NotNull HierarchicalConfiguration configuration) {
        WebRepositoryViewer newWebRepositoryViewer;
        Repository2VcsTypeConverter reverseConverter = this.vcsRepositoryManager.findReverseConverterFor(inputPluginKey);
        String pluginKey = reverseConverter != null ? reverseConverter.acceptedRepositoryPluginKey() : inputPluginKey;
        PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder().serverConfiguration(new HashMap<String, String>()).name(repositoryName).pluginKey(pluginKey);
        if (webRepositoryKey != null && (newWebRepositoryViewer = this.webRepositoryViewerManager.getNewWebRepositoryViewerInstance(webRepositoryKey)) != null) {
            newWebRepositoryViewer.populateFromConfig(configuration);
            builder.viewerPluginKey(webRepositoryKey);
            builder.legacyViewerXml(ConfigUtils.asXmlString((HierarchicalConfiguration)newWebRepositoryViewer.toConfiguration()));
            builder.viewerConfiguration(new HashMap<String, String>());
        }
        Repository newRepository = this.repositoryManager.getNewRepositoryInstance(pluginKey);
        newRepository.populateFromConfig(configuration);
        BranchAwareRepository bar = (BranchAwareRepository)Narrow.downTo((Object)newRepository, BranchAwareRepository.class);
        if (bar != null) {
            builder.vcsBranch(bar.getVcsBranch());
            builder.branchConfiguration(new HashMap<String, String>());
        }
        builder.changeDetectionConfiguration(RepositoryConfigurationServiceImpl.extractChangeDetectionOptionFromConfiguration(configuration));
        builder.legacyXml(ConfigUtils.asXmlString((HierarchicalConfiguration)newRepository.toConfiguration()));
        return builder.build();
    }

    public RepositoryDefinition createRepository(@NotNull Plan plan, @NotNull String repositoryName, @NotNull String pluginKey, @Nullable String webRepositoryKey, @NotNull HierarchicalConfiguration configuration, boolean buildTrigger) throws IllegalArgumentException {
        PartialVcsRepositoryData input = this.repositoryDataFromHierarchicalConfiguration(repositoryName, pluginKey, webRepositoryKey, configuration);
        PartialVcsRepositoryData result = this.vcsRepositoryConfigurationService.createPlanRepository(plan, input);
        PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, result.getId());
        return new RepositoryDefinitionImpl(new PlanRepositoryDefinitionImpl(planRepositoryLink, result));
    }

    public RepositoryDefinition editRepository(@NotNull Plan plan, @NotNull String repositoryName, @NotNull String pluginKey, @Nullable String webRepositoryKey, @NotNull RepositoryDefinition repositoryDefinition, @NotNull HierarchicalConfiguration configuration) throws IllegalArgumentException, IllegalStateException {
        if (NumberUtils.isCreatable((String)pluginKey)) {
            PartialVcsRepositoryData oldData = this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(repositoryDefinition.getId());
            long repositoryId = Long.parseLong(pluginKey);
            if (repositoryId == repositoryDefinition.getId() || oldData.getInheritedData().getId() == repositoryId) {
                return repositoryDefinition;
            }
            PartialVcsRepositoryData parent = this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(repositoryId);
            Preconditions.checkState((boolean)parent.isLinked());
            PartialVcsRepositoryDataImpl newData = PartialVcsRepositoryDataImpl.createChild(parent.getCompleteData());
            PartialVcsRepositoryData result = this.vcsRepositoryConfigurationService.replaceRepositoryInPlan(plan, parent.getCompleteData(), oldData, (PartialVcsRepositoryData)newData);
            PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, result.getId());
            return new RepositoryDefinitionImpl(new PlanRepositoryDefinitionImpl(planRepositoryLink, result));
        }
        PartialVcsRepositoryData input = this.repositoryDataFromHierarchicalConfiguration(repositoryName, pluginKey, webRepositoryKey, configuration);
        PartialVcsRepositoryData result = this.vcsRepositoryConfigurationService.editRepository(plan, repositoryDefinition.getId(), input);
        PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, result.getId());
        return new RepositoryDefinitionImpl(new PlanRepositoryDefinitionImpl(planRepositoryLink, result));
    }

    public Map<ImmutableJob, List<TaskDefinition>> getRelevantJobsForRepositoryIdChange(@NotNull ImmutablePlan plan, long repositoryId) {
        return this.vcsRepositoryConfigurationService.getRelevantJobsForRepositoryIdChange(plan, repositoryId);
    }

    public void shareRepository(@NotNull Plan plan, @NotNull RepositoryData repositoryData, @NotNull String repositoryName, @Nullable String userDescription, @NotNull User user) {
        PartialVcsRepositoryData partialVcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(repositoryData.getId());
        this.vcsRepositoryConfigurationService.shareRepository(plan, partialVcsRepositoryData, repositoryName, userDescription, user);
    }

    public RepositoryData editGlobalRepository(@NotNull String repositoryName, @NotNull String pluginKey, @Nullable String webRepositoryKey, @NotNull RepositoryData repositoryData, @NotNull HierarchicalConfiguration configuration) throws IllegalArgumentException, IllegalStateException {
        PartialVcsRepositoryData input = this.repositoryDataFromHierarchicalConfiguration(repositoryName, pluginKey, webRepositoryKey, configuration);
        PartialVcsRepositoryData result = this.vcsRepositoryConfigurationService.editLinkedRepository(repositoryData.getId(), input);
        return new RepositoryDataImpl(result.getCompleteData());
    }

    public RepositoryData createGlobalRepository(@NotNull String repositoryName, @NotNull String pluginKey, @Nullable String webRepositoryKey, @NotNull HierarchicalConfiguration configuration, boolean buildTrigger, @NotNull User user) throws IllegalArgumentException {
        return this.createGlobalRepository(repositoryName, pluginKey, webRepositoryKey, configuration, buildTrigger, user, RepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS);
    }

    public RepositoryData createGlobalRepository(@NotNull String repositoryName, @NotNull String pluginKey, @Nullable String webRepositoryKey, @NotNull HierarchicalConfiguration configuration, boolean buildTrigger, @NotNull User user, @NotNull RepositoryConfigurationService.LinkedRepositoryAccess accessOption) throws IllegalArgumentException {
        PartialVcsRepositoryData input = this.repositoryDataFromHierarchicalConfiguration(repositoryName, pluginKey, webRepositoryKey, configuration);
        PartialVcsRepositoryData result = this.vcsRepositoryConfigurationService.createLinkedRepository(input, user, accessOption);
        return new RepositoryDataImpl(result.getCompleteData());
    }

    public RepositoryDefinition attachGlobalRepositoryToPlan(Plan plan, long selectedGlobalRepositoryId, boolean buildTrigger) {
        PartialVcsRepositoryData result = this.vcsRepositoryConfigurationService.linkRepositoryToPlan(plan, selectedGlobalRepositoryId);
        PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)plan, result.getId());
        return new RepositoryDefinitionImpl(new PlanRepositoryDefinitionImpl(planRepositoryLink, result));
    }

    public void deleteGlobalRepository(long repositoryId) throws IllegalArgumentException, IllegalStateException {
        this.vcsRepositoryConfigurationService.deleteLinkedRepository(repositoryId);
    }

    public void deleteRepository(@NotNull Plan plan, long repositoryId) throws IllegalArgumentException, IllegalStateException {
        this.vcsRepositoryConfigurationService.deleteRepository(plan, repositoryId, Long.valueOf(-1L));
    }

    public void deleteRepository(@NotNull Plan plan, long repositoryId, long replacementReposiotryId) throws IllegalArgumentException, IllegalStateException {
        this.vcsRepositoryConfigurationService.deleteRepository(plan, repositoryId, Long.valueOf(replacementReposiotryId));
    }

    public void moveRepository(@NotNull PlanKey planKey, long repositoryId, long beforePosition, long afterPosition) throws IllegalArgumentException, IllegalStateException {
        Plan plan = this.planManager.getPlanByKey(planKey);
        this.vcsRepositoryConfigurationService.moveRepository(plan, repositoryId, beforePosition, afterPosition);
    }

    public boolean validateRepositoryName(@NotNull ImmutablePlan plan, @NotNull String name, @Nullable RepositoryDefinition repositoryDefinition) {
        return this.vcsRepositoryConfigurationService.validateRepositoryName(plan, name, (BambooIdProvider)repositoryDefinition);
    }

    public boolean validateGlobalRepositoryName(@NotNull String name, @Nullable RepositoryData repositoryData) {
        return this.vcsRepositoryConfigurationService.validateLinkedRepositoryName(name, (BambooIdProvider)repositoryData);
    }

    public boolean validateRestartableStatus(@NotNull ResultsSummary resultSummary) {
        return this.vcsRepositoryConfigurationService.validateRestartableStatus(resultSummary);
    }
}

