/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.core.BambooEntityWithOid;
import com.atlassian.bamboo.repository.LegacyRepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.utils.BambooInterners;
import com.google.common.base.Preconditions;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="VCS_LOCATION")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class RepositoryDataEntityImpl
extends BambooEntityWithOid
implements RepositoryDataEntity {
    private static final Logger log = Logger.getLogger(LegacyRepositoryDefinitionImpl.class);
    private String pluginKey;
    private String name;
    private String description;
    private String xmlData;
    private boolean markedForDeletion;
    private boolean global;
    private RepositoryDataEntity parent;

    public RepositoryDataEntityImpl(String pluginKey, String name, String description, String xmlData, boolean markedForDeletion, boolean global, RepositoryDataEntity parent) {
        this.pluginKey = BambooInterners.moduleKey((String)pluginKey);
        this.name = BambooInterners.intern((String)name);
        this.description = BambooInterners.intern((String)description);
        this.xmlData = xmlData;
        this.markedForDeletion = markedForDeletion;
        this.global = global;
        this.parent = parent;
    }

    public RepositoryDataEntityImpl(RepositoryDataEntity source) {
        this.pluginKey = source.getPluginKey();
        this.name = source.getName();
        this.description = source.getDescription();
        this.xmlData = source.getXmlData();
        this.markedForDeletion = source.isMarkedForDeletion();
        this.global = source.isGlobal();
        this.parent = source.getParent();
    }

    public RepositoryDataEntityImpl() {
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    public void setPluginKey(@NotNull String pluginKey) {
        this.pluginKey = pluginKey;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public String getXmlData() {
        Preconditions.checkNotNull((Object)this.xmlData);
        return this.xmlData;
    }

    public void setXmlData(@NotNull String xmlData) {
        this.xmlData = xmlData;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean isGlobal) {
        this.global = isGlobal;
    }

    @Nullable
    public RepositoryDataEntity getParent() {
        return this.parent;
    }

    public void setParent(@Nullable RepositoryDataEntity parent) {
        this.parent = parent;
    }
}

