/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class RepositoryDefinitionCacheIndicesImpl {
    private final Multimap<String, Long> repositoryIdsForPluginKey = HashMultimap.create();
    private final Multimap<Long, Long> descendants = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<String, Long> linkedRepositoryIdForName = new HashMap<String, Long>();

    synchronized void index(@NotNull VcsRepositoryData vcsRepositoryData) {
        this.repositoryIdsForPluginKey.put((Object)vcsRepositoryData.getPluginKey(), (Object)vcsRepositoryData.getId());
        this.descendants.put((Object)vcsRepositoryData.getParentId(), (Object)vcsRepositoryData.getId());
        this.descendants.put((Object)vcsRepositoryData.getRootVcsRepositoryId(), (Object)vcsRepositoryData.getId());
        if (vcsRepositoryData.isLinked()) {
            this.linkedRepositoryIdForName.put(vcsRepositoryData.getName(), vcsRepositoryData.getId());
        }
    }

    synchronized void deindex(long repositoryId) {
        this.repositoryIdsForPluginKey.values().remove(repositoryId);
        this.descendants.values().removeAll(Collections.singleton(repositoryId));
        this.linkedRepositoryIdForName.values().remove(repositoryId);
    }

    public synchronized Collection<Long> findRepositoriesByPluginKey(String pluginKey) {
        return new ArrayList<Long>(this.repositoryIdsForPluginKey.get((Object)pluginKey));
    }

    public synchronized Collection<Long> getRepositoriesAffectedWithChange(long repositoryId) {
        HashSet<Long> ids = new HashSet<Long>(this.descendants.get((Object)repositoryId));
        ids.add(repositoryId);
        return ids;
    }

    public synchronized Optional<Long> findLinkedRepositoryByName(@NotNull String name) {
        return Optional.ofNullable(this.linkedRepositoryIdForName.getOrDefault(name, null));
    }

    public synchronized void clear() {
        this.repositoryIdsForPluginKey.clear();
        this.descendants.clear();
        this.linkedRepositoryIdForName.clear();
    }
}

