/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.EncryptedRepositoryDefinitionAccessor;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.specs.RssRepositoryPermissionDao;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationImpl;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class RepositoryDefinitionManagerImpl
implements RepositoryDefinitionManager {
    private static final Logger log = Logger.getLogger(RepositoryDefinitionManagerImpl.class);
    private final RepositoryDefinitionDao repositoryDefinitionDao;
    private final PlanRepositoryLinkDao planRepositoryLinkDao;
    private final RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    private final RssRepositoryPermissionDao rssRepositoryPermissionDao;
    @Lazy
    @Inject
    private CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    @Lazy
    @Inject
    private SecretEncryptionService secretEncryptionService;

    public RepositoryDefinitionManagerImpl(RepositoryDefinitionDao repositoryDefinitionDao, PlanRepositoryLinkDao planRepositoryLinkDao, RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter, RssRepositoryPermissionDao rssRepositoryPermissionDao) {
        this.repositoryDefinitionDao = repositoryDefinitionDao;
        this.planRepositoryLinkDao = planRepositoryLinkDao;
        this.rawRepositoryConfigurationXmlConverter = rawRepositoryConfigurationXmlConverter;
        this.rssRepositoryPermissionDao = rssRepositoryPermissionDao;
    }

    public PlanRepositoryLink getPlanRepositoryLink(@NotNull ImmutablePlan plan, long repositoryId) {
        return this.planRepositoryLinkDao.getPlanRepositoryLink((PlanIdentifier)plan, repositoryId);
    }

    public PlanRepositoryLink getPlanRepositoryLinkByName(@NotNull ImmutablePlan plan, @NotNull String repositoryName) {
        return this.planRepositoryLinkDao.getPlanRepositoryLinkByName((PlanIdentifier)plan, repositoryName);
    }

    @NotNull
    public List<PlanRepositoryLink> getPlanRepositoryLinks(@NotNull ImmutablePlan plan) {
        return this.planRepositoryLinkDao.getPlanRepositoryLinks(plan);
    }

    @Nullable
    public RepositoryDataEntity getRepositoryDataEntity(long id) {
        return this.decrypt(this.repositoryDefinitionDao.findById(id));
    }

    @NotNull
    public List<RepositoryDefinition> getRepositoryDefinitionsForPlan(@NotNull ImmutablePlan plan) {
        return this.getPlanRepositoryDefinitions((PlanIdentifier)plan).stream().map(RepositoryDefinitionImpl::new).collect(Collectors.toList());
    }

    @NotNull
    public List<PlanRepositoryDefinition> getPlanRepositoryDefinitions(@NotNull PlanIdentifier plan) {
        return this.planRepositoryLinkDao.getPlanRepositoryLinks(plan).stream().map(prl -> new PlanRepositoryDefinitionImpl((PlanRepositoryLink)prl, this.entityToUnmergedData(prl.getRepositoryDataEntity()))).collect(Collectors.toList());
    }

    @NotNull
    public List<PartialVcsRepositoryData> getPlanRepositoriesForExport(@NotNull PlanIdentifier plan) {
        return this.planRepositoryLinkDao.getPlanRepositoryLinks(plan).stream().map(prl -> this.entityToUnmergedData(prl.getRepositoryDataEntity(), false)).collect(Collectors.toList());
    }

    public List<PlanRepositoryLink> getPlansUsingRepository(long repositoryId) {
        return this.planRepositoryLinkDao.getPlansUsingRepository(repositoryId);
    }

    @NotNull
    public List<PlanIdentifier> getIdentifiersOfPlansUsingRepositoryOrItsDirectChildren(long repositoryId) {
        return this.planRepositoryLinkDao.getIdentifiersOfPlansUsingRepositoryOrItsDirectChildren(repositoryId);
    }

    public List<RepositoryData> getGlobalRepositoryDefinitions() {
        return this.getGlobalRepositoryDefinitionsUnrestricted();
    }

    public List<RepositoryData> getGlobalRepositoryDefinitionsForAdministration() {
        return this.getGlobalRepositoryDefinitionsUnrestricted();
    }

    public List<RepositoryData> getGlobalRepositoryDefinitionsUnrestricted() {
        return this.getLinkedRepositoriesUnrestricted().stream().map(RepositoryDataImpl::new).collect(Collectors.toList());
    }

    @NotNull
    public List<VcsRepositoryData> getLinkedRepositories() {
        return this.getLinkedRepositoriesUnrestricted();
    }

    public List<VcsRepositoryData> getLinkedRepositoriesForAdministration() {
        return this.getLinkedRepositoriesUnrestricted();
    }

    @Nullable
    public VcsRepositoryData entityToVcsData(@Nullable RepositoryDataEntity input) {
        return input != null ? new VcsRepositoryDataImpl(this.entityToUnmergedData(input).getCompleteData()) : null;
    }

    @Nullable
    public VcsRepositoryData getVcsRepositoryData(long repositoryId) {
        return this.entityToVcsData(this.getRepositoryDataEntity(repositoryId));
    }

    public PartialVcsRepositoryData entityToUnmergedData(@NotNull RepositoryDataEntity entity) {
        return this.entityToUnmergedData(entity, true);
    }

    private PartialVcsRepositoryData entityToUnmergedData(@NotNull RepositoryDataEntity entity, boolean doDecrypt) {
        PartialVcsRepositoryData parent = entity.getParent() != null ? this.entityToUnmergedData(entity.getParent()) : null;
        return new PartialVcsRepositoryDataImpl(entity, this.rawRepositoryConfigurationXmlConverter.fromEntity(doDecrypt ? this.decrypt(entity) : entity), parent != null ? parent.getCompleteData() : null);
    }

    @Nullable
    public PartialVcsRepositoryData getVcsRepositoryDataForEditing(long repositoryId) {
        RepositoryDataEntity entity = this.getRepositoryDataEntity(repositoryId);
        if (entity == null) {
            return null;
        }
        return this.entityToUnmergedData(entity);
    }

    public List<VcsRepositoryData> getLinkedRepositoriesUnrestricted() {
        return this.repositoryDefinitionDao.getGlobalRepositoryDefinitions().stream().map(this::decrypt).map(this::entityToVcsData).collect(Collectors.toList());
    }

    public long saveRepositoryDefinition(RepositoryDataEntity repositoryData) {
        RepositoryDataEntity encrypted = this.encrypt(repositoryData);
        this.repositoryDefinitionDao.save((BambooObject)encrypted);
        repositoryData.setId(encrypted.getId());
        repositoryData.setOid(encrypted.getOid());
        return repositoryData.getId();
    }

    public void saveRepositoryDefinitions(@NotNull Collection<RepositoryDataEntity> repositoriesBeingCreated) {
        repositoriesBeingCreated.forEach(this::saveRepositoryDefinition);
    }

    public long savePlanRepositoryWithDefinition(@NotNull PlanRepositoryLink planRepository) {
        RepositoryDataEntity encryptedRepository = this.encrypt(planRepository.getRepositoryDataEntity());
        this.repositoryDefinitionDao.save((BambooObject)encryptedRepository);
        planRepository.setRepositoryDataEntity(this.repositoryDefinitionDao.findById(encryptedRepository.getId()));
        this.planRepositoryLinkDao.save((BambooObject)planRepository);
        return planRepository.getRepositoryDataEntity().getId();
    }

    public void savePlanRepositoryLink(@NotNull PlanRepositoryLink planRepository) {
        this.savePlanRepositoryWithDefinition(planRepository);
    }

    public void savePlanRepositoryLinks(@NotNull List<PlanRepositoryLink> planRepositories) {
        planRepositories.forEach(this::savePlanRepositoryLink);
    }

    public void removeRepositoryFromPlan(@NotNull PlanRepositoryLink planRepository) {
        long parentId = planRepository.getRepositoryDataEntity().getId();
        this.planRepositoryLinkDao.removeRepositoryFromPlan(planRepository);
        this.planRepositoryLinkDao.removeLinksByParentRepositoryId(parentId);
        this.repositoryDefinitionDao.markForDeletionByParentId(parentId);
        if (!planRepository.getRepositoryDataEntity().isGlobal()) {
            this.removeRepositoryIfUnused(planRepository.getRepositoryDataEntity());
        }
    }

    public void removeRepositoryIfUnused(RepositoryDataEntity repositoryDataEntity) {
        this.removeRssRepositoryPermissions(repositoryDataEntity.getId());
        this.repositoryDefinitionDao.removeRepositoryIfUnused(repositoryDataEntity);
    }

    public void removeUnusedRepositories() {
        HashSet deletedRepositories = new HashSet(this.repositoryDefinitionDao.findAllRepositoryIds());
        try {
            this.repositoryDefinitionDao.removeUnusedRepositories();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Set repositoryIdsAfterDeletion = this.repositoryDefinitionDao.findAllRepositoryIds();
        deletedRepositories.removeAll(repositoryIdsAfterDeletion);
        if (!deletedRepositories.isEmpty()) {
            log.debug((Object)("Removing " + deletedRepositories + " from cache"));
            deletedRepositories.forEach(arg_0 -> ((CachedRepositoryDefinitionManager)this.cachedRepositoryDefinitionManager).remove(arg_0));
        }
    }

    public void removeRepositoriesForPlan(Plan plan) {
        Collection toRemove = this.repositoryDefinitionDao.getPrivateRepositoryDefinitionsByPlan(plan);
        this.planRepositoryLinkDao.detachAllRepositoriesFromPlan((ImmutablePlan)plan);
        for (RepositoryDataEntity repositoryDataEntity : toRemove) {
            this.removeRepositoryIfUnused(repositoryDataEntity);
        }
    }

    public List<PlanIdentifier> getIdentifiersOfPlansUsingRepository(long repositoryId) {
        return this.planRepositoryLinkDao.getIdentifiersOfPlansUsingRepository(repositoryId);
    }

    @NotNull
    public List<RepositoryDataEntity> findRepositoriesByPluginKey(@NotNull String pluginKey) {
        return this.repositoryDefinitionDao.findRepositoriesByPluginKey(pluginKey).stream().map(this::decrypt).collect(Collectors.toList());
    }

    public VcsRepositoryData getVcsRepositoryDataByOid(BambooEntityOid oid) {
        return this.entityToVcsData(this.decrypt((RepositoryDataEntity)this.repositoryDefinitionDao.findByOid(oid, RepositoryDataEntity.class)));
    }

    @Nullable
    public VcsRepositoryData getLinkedRepositoryByName(String name) {
        return this.entityToVcsData(this.decrypt(this.repositoryDefinitionDao.findLinkedRepositoryByName(name)));
    }

    @NotNull
    private RepositoryDataEntity encrypt(@NotNull RepositoryDataEntity repository) {
        RawRepositoryConfigurationImpl fromEntity = (RawRepositoryConfigurationImpl)this.rawRepositoryConfigurationXmlConverter.fromEntity(repository);
        RawRepositoryConfigurationImpl.Builder builder = RawRepositoryConfigurationImpl.builder().copyOf(fromEntity);
        RepositoryDataEntityImpl encryptedEntity = new RepositoryDataEntityImpl(repository);
        encryptedEntity.setId(repository.getId());
        encryptedEntity.setOid(repository.getOid());
        if (StringUtils.isEmpty((CharSequence)fromEntity.getLegacyXml())) {
            Map<String, String> serverConfiguration = fromEntity.getServerConfiguration();
            if (serverConfiguration != null) {
                HashMap<String, String> updatedServerConfiguration = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : serverConfiguration.entrySet()) {
                    if (EncryptedRepositoryDefinitionAccessor.isSecret((String)entry.getKey()) && !this.secretEncryptionService.isEncrypted(entry.getValue())) {
                        updatedServerConfiguration.put(entry.getKey(), this.secretEncryptionService.encrypt(entry.getValue()));
                        continue;
                    }
                    updatedServerConfiguration.put(entry.getKey(), entry.getValue());
                }
                builder.serverConfiguration(updatedServerConfiguration);
                encryptedEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(builder.build()));
            }
        } else {
            XMLConfiguration legacyXml = ConfigUtils.getXmlConfigFromXmlString((String)fromEntity.getLegacyXml());
            Iterator iter = legacyXml.getKeys();
            while (iter.hasNext()) {
                String key = String.valueOf(iter.next());
                if (!EncryptedRepositoryDefinitionAccessor.isSecret((String)key)) continue;
                legacyXml.setProperty(key, (Object)this.secretEncryptionService.encrypt(legacyXml.getString(key, "")));
            }
            builder.legacyXml(ConfigUtils.asXmlString((XMLConfiguration)legacyXml));
            encryptedEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(builder.build()));
        }
        return encryptedEntity;
    }

    @Nullable
    private RepositoryDataEntity decrypt(@Nullable RepositoryDataEntity repositoryDataEntity) {
        if (repositoryDataEntity == null) {
            return null;
        }
        RawRepositoryConfigurationImpl fromEntity = (RawRepositoryConfigurationImpl)this.rawRepositoryConfigurationXmlConverter.fromEntity(repositoryDataEntity);
        RawRepositoryConfigurationImpl.Builder builder = RawRepositoryConfigurationImpl.builder().copyOf(fromEntity);
        boolean updated = false;
        RepositoryDataEntityImpl result = new RepositoryDataEntityImpl(repositoryDataEntity);
        result.setId(repositoryDataEntity.getId());
        result.setOid(repositoryDataEntity.getOid());
        if (StringUtils.isBlank((CharSequence)fromEntity.getLegacyXml())) {
            Map<String, String> serverConfiguration = fromEntity.getServerConfiguration();
            if (serverConfiguration != null) {
                HashMap<String, String> updatedServerConfiguration = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : serverConfiguration.entrySet()) {
                    if (EncryptedRepositoryDefinitionAccessor.isSecret((String)entry.getKey()) && StringUtils.isNotEmpty((CharSequence)entry.getValue()) && this.secretEncryptionService.isEncrypted(entry.getValue())) {
                        updatedServerConfiguration.put(entry.getKey(), this.secretEncryptionService.decrypt(entry.getValue()));
                        updated = true;
                        continue;
                    }
                    updatedServerConfiguration.put(entry.getKey(), entry.getValue());
                }
                builder.serverConfiguration(updatedServerConfiguration);
            }
        } else {
            XMLConfiguration legacyXml = ConfigUtils.getXmlConfigFromXmlString((String)fromEntity.getLegacyXml());
            Iterator iter = legacyXml.getKeys();
            while (iter.hasNext()) {
                String value;
                String key = String.valueOf(iter.next());
                if (!EncryptedRepositoryDefinitionAccessor.isSecret((String)key) || !StringUtils.isNotEmpty((CharSequence)(value = legacyXml.getString(key, ""))) || !this.secretEncryptionService.isEncrypted(value)) continue;
                legacyXml.setProperty(key, (Object)this.secretEncryptionService.decrypt(value));
                updated = true;
            }
            builder.legacyXml(ConfigUtils.asXmlString((XMLConfiguration)legacyXml));
        }
        if (updated) {
            result.setXmlData(this.rawRepositoryConfigurationXmlConverter.asXml(builder.build()));
            return result;
        }
        return repositoryDataEntity;
    }

    private void removeRssRepositoryPermissions(long repositoryId) {
        List rssRepositoryPermissions = this.rssRepositoryPermissionDao.findByRepositoryId(repositoryId);
        rssRepositoryPermissions.forEach(arg_0 -> ((RssRepositoryPermissionDao)this.rssRepositoryPermissionDao).delete(arg_0));
    }
}

