/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionException;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.RepositoryPositionProvider;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Internal
public class RepositoryFunctions {
    private static final Logger log = Logger.getLogger(RepositoryFunctions.class);

    private RepositoryFunctions() {
    }

    public static Function<String, Result<RepositoryDefinitionException, RepositoryDefinition>> idSelectorToRepositoryDefinition(@NotNull CommonTaskContext commonTaskContext) {
        return new IdSelectorToRepositoryDefinition<RepositoryDefinition>(commonTaskContext.getCommonContext().getRepositoryDefinitionMap(), (Map<String, String>)commonTaskContext.getConfigurationMap());
    }

    public static Function<String, Result<RepositoryDefinitionException, PlanRepositoryDefinition>> idSelectorToPlanRepositoryDefinition(@NotNull CommonTaskContext commonTaskContext) {
        return new IdSelectorToRepositoryDefinition<PlanRepositoryDefinition>(commonTaskContext.getCommonContext().getVcsRepositoryMap(), (Map<String, String>)commonTaskContext.getConfigurationMap());
    }

    public static Function<String, Result<RepositoryDefinitionException, RepositoryDefinition>> idSelectorToRepositoryDefinition(@NotNull List<RepositoryDefinition> repositoryDefinitionList, @NotNull TaskDefinition taskDefinition) {
        return new IdSelectorToRepositoryDefinition<RepositoryDefinition>(repositoryDefinitionList, (Map<String, String>)taskDefinition.getConfiguration());
    }

    public static Function<String, Result<RepositoryDefinitionException, PlanRepositoryDefinition>> idSelectorToPlanRepositoryDefinition(@NotNull List<PlanRepositoryDefinition> repositoryDefinitionList, @NotNull TaskDefinition taskDefinition) {
        return new IdSelectorToRepositoryDefinition<PlanRepositoryDefinition>(repositoryDefinitionList, (Map<String, String>)taskDefinition.getConfiguration());
    }

    public static Function<String, Result<RepositoryDefinitionException, RepositoryDefinition>> idSelectorToRepositoryDefinition(@NotNull Map<Long, RepositoryDefinition> repositoryDefinitionMap, @NotNull TaskDefinition taskDefinition) {
        return new IdSelectorToRepositoryDefinition<RepositoryDefinition>(repositoryDefinitionMap, (Map<String, String>)taskDefinition.getConfiguration());
    }

    public static Function<String, Result<RepositoryDefinitionException, PlanRepositoryDefinition>> idSelectorToPlanRepositoryDefinition(@NotNull Map<Long, PlanRepositoryDefinition> repositoryDefinitionMap, @NotNull TaskDefinition taskDefinition) {
        return new IdSelectorToRepositoryDefinition<PlanRepositoryDefinition>(repositoryDefinitionMap, (Map<String, String>)taskDefinition.getConfiguration());
    }

    private static class IdSelectorToRepositoryDefinition<T extends RepositoryPositionProvider>
    implements Function<String, Result<RepositoryDefinitionException, T>> {
        @NotNull
        private final Map<String, String> taskConfiguration;
        @NotNull
        private final Map<Long, T> repositoryDefinitionMap;

        public IdSelectorToRepositoryDefinition(@NotNull List<T> repositoryDefinitionList, @NotNull Map<String, String> taskConfiguration) {
            this.repositoryDefinitionMap = repositoryDefinitionList.stream().collect(Collectors.toMap(BambooIdProvider::getId, UnaryOperator.identity()));
            this.taskConfiguration = taskConfiguration;
        }

        public IdSelectorToRepositoryDefinition(@NotNull Map<Long, T> repositoryDefinitionMap, @NotNull Map<String, String> taskConfiguration) {
            this.repositoryDefinitionMap = repositoryDefinitionMap;
            this.taskConfiguration = taskConfiguration;
        }

        public Result<RepositoryDefinitionException, T> apply(String input) {
            if (this.repositoryDefinitionMap.isEmpty()) {
                return Result.exception((Throwable)new RepositoryDefinitionException("Job has task that uses source control but no repositories exists."));
            }
            String repositoryIdString = this.taskConfiguration.get(input);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)repositoryIdString), (Object)("Task configuration does not contain selector " + input + ": " + this.taskConfiguration));
            if (RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY.equals(repositoryIdString)) {
                return Result.result((Object)this.repositoryDefinitionMap.values().stream().filter(r -> 0 == r.getPosition()).findFirst().orElseGet(() -> null));
            }
            Long repositoryId = Long.parseLong(repositoryIdString);
            RepositoryPositionProvider repositoryDefinition = (RepositoryPositionProvider)this.repositoryDefinitionMap.get(repositoryId);
            if (repositoryDefinition != null) {
                return Result.result((Object)repositoryDefinition);
            }
            return Result.exception((Throwable)new RepositoryDefinitionException("Task failed since repository with id " + repositoryId + " does not exist. It may have been deleted, please update the task and pick a new repository"));
        }
    }
}

